SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for mac_actor
-- ----------------------------
DROP TABLE IF EXISTS `mac_actor`;
CREATE TABLE `mac_actor` (
  `actor_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `type_id_1` smallint(6) unsigned NOT NULL DEFAULT '0',
  `actor_name` varchar(255) NOT NULL DEFAULT '',
  `actor_en` varchar(255) NOT NULL DEFAULT '',
  `actor_alias` varchar(255) NOT NULL DEFAULT '',
  `actor_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `actor_lock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `actor_letter` char(1) NOT NULL DEFAULT '',
  `actor_sex` char(1) NOT NULL DEFAULT '',
  `actor_color` varchar(6) NOT NULL DEFAULT '',
  `actor_pic` varchar(1024) NOT NULL DEFAULT '',
  `actor_blurb` varchar(255) NOT NULL DEFAULT '',
  `actor_remarks` varchar(100) NOT NULL DEFAULT '',
  `actor_area` varchar(20) NOT NULL DEFAULT '',
  `actor_height` varchar(10) NOT NULL DEFAULT '',
  `actor_weight` varchar(10) NOT NULL DEFAULT '',
  `actor_birthday` varchar(10) NOT NULL DEFAULT '',
  `actor_birtharea` varchar(20) NOT NULL DEFAULT '',
  `actor_blood` varchar(10) NOT NULL DEFAULT '',
  `actor_starsign` varchar(10) NOT NULL DEFAULT '',
  `actor_school` varchar(20) NOT NULL DEFAULT '',
  `actor_works` varchar(255) NOT NULL DEFAULT '',
  `actor_tag` varchar(255) NOT NULL DEFAULT '',
  `actor_class` varchar(255) NOT NULL DEFAULT '',
  `actor_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `actor_time` int(10) unsigned NOT NULL DEFAULT '0',
  `actor_time_add` int(10) unsigned NOT NULL DEFAULT '0',
  `actor_time_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `actor_time_make` int(10) unsigned NOT NULL DEFAULT '0',
  `actor_hits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_hits_day` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_hits_week` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_hits_month` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_score` decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  `actor_score_all` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_score_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_up` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `actor_tpl` varchar(30) NOT NULL DEFAULT '',
  `actor_jumpurl` varchar(150) NOT NULL DEFAULT '',
  `actor_content` text NOT NULL,
  PRIMARY KEY (`actor_id`),
  KEY `type_id` (`type_id`) USING BTREE,
  KEY `type_id_1` (`type_id_1`) USING BTREE,
  KEY `actor_name` (`actor_name`) USING BTREE,
  KEY `actor_en` (`actor_en`) USING BTREE,
  KEY `actor_letter` (`actor_letter`) USING BTREE,
  KEY `actor_level` (`actor_level`) USING BTREE,
  KEY `actor_time` (`actor_time`) USING BTREE,
  KEY `actor_time_add` (`actor_time_add`) USING BTREE,
  KEY `actor_sex` (`actor_sex`),
  KEY `actor_area` (`actor_area`),
  KEY `actor_up` (`actor_up`),
  KEY `actor_down` (`actor_down`),
  KEY `actor_tag` (`actor_tag`),
  KEY `actor_class` (`actor_class`),
  KEY `actor_score` (`actor_score`),
  KEY `actor_score_all` (`actor_score_all`),
  KEY `actor_score_num` (`actor_score_num`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_actor
-- ----------------------------
INSERT INTO `mac_actor` VALUES ('1', '7', '0', '初音未来', 'chuyinweilai', '', '1', '0', 'C', '女', '', 'https://api.modelym.com/actor/3.png', '初音未来（初音ミク/Hatsune Miku），是2007年8月31日由CRYPTON FUTURE MEDIA以Yamaha的VOCALOID系列语音合成程序为基础开发的音源库，音源数据资料采样于日', '', '日本', '158', '42', '2007年8月31日', '北海道札幌', 'B', '处女座', '', '', '', '', '0', '1625319173', '1605692369', '0', '0', '7800', '247', '413', '3205', '8.0', '158', '26', '921', '591', '', '', '<p>初音未来（初音ミク/Hatsune Miku），是2007年8月31日由CRYPTON FUTURE MEDIA以Yamaha的VOCALOID系列语音合成程序为基础开发的音源库，音源数据资料采样于日本声优藤田咲。</p><p>2010年4月30日，发布初音未来6种不同声调的版本“初音未来Append”。2013年8月31日，初音未来英文版本同VOCALOID3一并发行。 [1]&nbsp; 此外，初音未来还担任日本音乐团体Sound Horizon的演唱与合唱。随着“初音未来”声库的发售，这种成功的营销方式大幅改变了电子音乐人对于音乐业的认知和整个行业的格局。在衍生文化现象后，初音未来可指代包装封面上的那位葱色头发的少女形象，还可指活跃在动画漫画中出现的“人气歌手”。</p><p>近年来，初音未来成为各大厂商的“宠儿”，代言、授权产品种类从互联网、时装、汽车到生活用品，世界各地都有其踪迹。</p><p><br/></p>');
INSERT INTO `mac_actor` VALUES ('2', '7', '0', '洛天依', 'luotianyi', '', '1', '0', 'L', '女', '', 'https://api.modelym.com/actor/5.png', '洛天依是以Yamaha公司的VOCALOID3语音合成引擎为基础制作的全世界第一款VOCALOID中文声库和虚拟形象 [1]  。2012年3月22日，洛天依的形象设计首次公布 [2]&nb', '', '大陆', '156', '41', '7月12日', '上海', 'A', '巨蟹座', '', '', '', '', '0', '1625319762', '1605793836', '0', '0', '5352', '276', '427', '2423', '5.0', '22', '40', '249', '190', '', '', '<p>洛天依是以Yamaha公司的VOCALOID3语音合成引擎为基础制作的全世界第一款VOCALOID中文声库和虚拟形象 [1]&nbsp; 。</p><p>2012年3月22日，洛天依的形象设计首次公布 [2]&nbsp; 。同年7月12日，第八届中国国际动漫游戏博览会正式推出洛天依的声库 [3]&nbsp; ，洛天依的音源是国内配音演员山新 [2]&nbsp; 。</p><p>2016年2月2日，洛天依与杨钰莹登上湖南卫视小年夜春晚合唱《花儿纳吉》，成为首位登上中国主流电视媒体的虚拟歌手。2016年10月15日，登上湖南卫视第十一届金鹰节互联盛典，搭档圈9和付辛博共同演唱《权御天下》和《刀剑如梦》 [4]&nbsp; 。2016年12月31日，与马可在湖南卫视跨年晚会演唱《九九八十一》和《追光使者》。2017年12月31日，洛天依与周华健在江苏卫视跨年晚会演唱《Let it go》，此次江苏卫视跨年的首秀，是洛天依首次演唱英文这一语种 [5]&nbsp; 。2018年3月31日，和京剧名家王珮瑜在中央电视台综合频道《经典咏流传》跨界合作演绎《但愿人长久》</p><p><br/></p>');
INSERT INTO `mac_actor` VALUES ('3', '7', '0', '东方栀子', 'dongfangzhizi', '', '1', '0', 'D', '女', '', 'https://api.modelym.com/actor/2.png', '东方栀子是由天津电视台创作、在“中国文化艺术奖首届动漫奖颁奖典礼”上亮相的一名虚拟歌手。出道时因其大量民众质疑其抄袭初音未来形象，官方停止后续开发。后来，她被很多二次元同人爱好者团体“养活”，同人爱好', '', '大陆', '165', '45', '12.27', '', 'B', '摩羯座', '', '', '', '', '0', '1625320298', '1605794053', '0', '0', '8668', '213', '937', '2693', '5.0', '334', '39', '759', '159', '', '', '<p>东方栀子是由天津电视台创作、在“中国文化艺术奖首届动漫奖颁奖典礼”上亮相的一名虚拟歌手。出道时因其大量民众质疑其抄袭初音未来形象，官方停止后续开发。</p><p>后来，她被很多二次元同人爱好者团体“养活”，同人爱好者团体对东方栀子进行了二次创作，录制了UTAU和袅袅的音源，使东方栀子成为一名虚拟歌姬。由于粉丝的同人创作，东方栀子的公众形象大有改观。</p><p><br/></p>');
INSERT INTO `mac_actor` VALUES ('4', '7', '0', '乐正绫', 'lezhengling', '', '1', '0', 'L', '女', '', 'https://api.modelym.com/actor/4.png', '乐正绫是上海禾念信息科技有限公司以雅马哈公司的VOCALOID 3语音合成引擎为基础制作的一款中文VOCALOID声库和虚拟形象。 [1] 乐正绫的声库于2015年7月1日正式推出并发售，于', '', '大陆', '160', '41', '4月12日', '上海', 'C', '白羊座', '', '', '', '', '0', '1625320310', '1605794200', '0', '0', '6546', '41', '337', '2601', '7.0', '492', '65', '88', '430', '', '', '<p>乐正绫是上海禾念信息科技有限公司以雅马哈公司的VOCALOID 3语音合成引擎为基础制作的一款中文VOCALOID声库和虚拟形象。 [1]&nbsp;</p><p>乐正绫的声库于2015年7月1日正式推出并发售，于2015年7月17日在广州第十届萤火虫动漫游戏嘉年华上正式推出。</p><p>乐正绫的音源是国内网络歌手祈Inory，形象由“rikuhao”初稿设计，经ideolo改编整合后完成。</p><p>乐正绫（yuèzhèng líng）姓乐正，名绫。设定中哥哥为乐正龙牙。</p><p>2020年10月8日10:14，乐正绫的歌曲《九九八十一》达到一千万播放量，达成“VOCALOID中文神话曲”称号。该歌曲是第二首中文神话曲（第一首是洛天依、言和的《普通DISCO》），乐正绫的第一首神话曲。乐正绫也因此成为中国第三名拥有神话曲的虚拟歌手。</p><p><br/></p>');
INSERT INTO `mac_actor` VALUES ('5', '7', '0', '嫣汐', 'yanxi', '', '1', '0', 'Y', '女', '', 'https://api.modelym.com/actor/1.png', '嫣汐是厦门优他动漫制作设计有限公司以独立开发的MUTA语音合成引擎为基础的具备感情模式的中文声库和虚拟形象。嫣汐的音源是樱桦Cheryl，嫣汐第三版人设由Rosele设计完成。', '', '大陆', '167', '47', '8月14日', '陕西西安', '', '狮子座', '', '', '', '', '0', '1625320317', '1605794427', '0', '0', '9715', '237', '432', '4502', '9.0', '21', '83', '483', '150', '', '', '<p>嫣汐是厦门优他动漫制作设计有限公司以独立开发的MUTA语音合成引擎为基础的具备感情模式的中文声库和虚拟形象。嫣汐的音源是樱桦Cheryl，嫣汐第三版人设由Rosele设计完成。</p>');
INSERT INTO `mac_actor` VALUES ('6', '7', '0', '言和', 'yanhe', '', '1', '0', 'Y', '女', '', 'https://api.modelym.com/actor/6.png', '言和是Vsinger（上海禾念信息科技有限公司）旗下以雅马哈的VOCALOID3语音合成引擎为基础制作的一款VOCALOID中文女歌手虚拟形象，是继洛天依后第二款以中文为演唱语言的VOCALOID3中文声库。 [1]  音源提供者是国内配音演员刘婧荦，形象由“MQ”（阿全）设计并完成。', '', '大陆', '170', '45', '2013-07-11', '上海', '', '巨蟹', '', '', '', '', '0', '1627977069', '1627977047', '1681043855', '0', '6767', '1', '1', '1', '4.0', '46', '7', '929', '506', '', '', '<p>言和是Vsinger（上海禾念信息科技有限公司）旗下以雅马哈的VOCALOID3语音合成引擎为基础制作的一款VOCALOID中文女歌手虚拟形象，是继洛天依后第二款以中文为演唱语言的VOCALOID3中文声库。 [1]&nbsp; 音源提供者是国内配音演员刘婧荦，形象由“MQ”（阿全）设计并完成。</p><p><br/></p><p>言和是继洛天依后的第二位V家中文虚拟女歌手。外表帅气、内心温柔。略带中性的声线是言和的独特魅力。</p><p><br/></p><p>言和形象以公开募集的形式，最终于2013年7月11日正式推出。言和声库于2013年7月11日正式发布。</p><p><br/></p>');

-- ----------------------------
-- Table structure for mac_admin
-- ----------------------------
DROP TABLE IF EXISTS `mac_admin`;
CREATE TABLE `mac_admin` (
  `admin_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `admin_name` varchar(30) NOT NULL DEFAULT '',
  `admin_pwd` char(32) NOT NULL DEFAULT '',
  `admin_random` char(32) NOT NULL DEFAULT '',
  `admin_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `admin_auth` text NOT NULL,
  `admin_login_time` int(10) unsigned NOT NULL DEFAULT '0',
  `admin_login_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `admin_login_num` int(10) unsigned NOT NULL DEFAULT '0',
  `admin_last_login_time` int(10) unsigned NOT NULL DEFAULT '0',
  `admin_last_login_ip` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`admin_id`),
  KEY `admin_name` (`admin_name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_admin
-- ----------------------------
INSERT INTO `mac_admin` VALUES ('1', 'admin', 'a66abb5684c45962d887564f08346e8d', '', '1', '', '0', '0', '0', '0', '0');

-- ----------------------------
-- Table structure for mac_annex
-- ----------------------------
DROP TABLE IF EXISTS `mac_annex`;
CREATE TABLE `mac_annex` (
  `annex_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `annex_time` int(10) unsigned NOT NULL DEFAULT '0',
  `annex_file` varchar(255) NOT NULL DEFAULT '',
  `annex_size` int(10) unsigned NOT NULL DEFAULT '0',
  `annex_type` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`annex_id`),
  KEY `annex_time` (`annex_time`),
  KEY `annex_file` (`annex_file`),
  KEY `annex_type` (`annex_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_annex
-- ----------------------------

-- ----------------------------
-- Table structure for mac_art
-- ----------------------------
DROP TABLE IF EXISTS `mac_art`;
CREATE TABLE `mac_art` (
  `art_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `type_id_1` smallint(6) unsigned NOT NULL DEFAULT '0',
  `group_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `art_name` varchar(255) NOT NULL DEFAULT '',
  `art_sub` varchar(255) NOT NULL DEFAULT '',
  `art_en` varchar(255) NOT NULL DEFAULT '',
  `art_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `art_letter` char(1) NOT NULL DEFAULT '',
  `art_color` varchar(6) NOT NULL DEFAULT '',
  `art_from` varchar(30) NOT NULL DEFAULT '',
  `art_author` varchar(30) NOT NULL DEFAULT '',
  `art_tag` varchar(100) NOT NULL DEFAULT '',
  `art_class` varchar(255) NOT NULL DEFAULT '',
  `art_pic` varchar(1024) NOT NULL DEFAULT '',
  `art_pic_thumb` varchar(1024) NOT NULL DEFAULT '',
  `art_pic_slide` varchar(1024) NOT NULL DEFAULT '',
  `art_pic_screenshot` text,
  `art_blurb` varchar(255) NOT NULL DEFAULT '',
  `art_remarks` varchar(100) NOT NULL DEFAULT '',
  `art_jumpurl` varchar(150) NOT NULL DEFAULT '',
  `art_tpl` varchar(30) NOT NULL DEFAULT '',
  `art_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `art_lock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `art_points` smallint(6) unsigned NOT NULL DEFAULT '0',
  `art_points_detail` smallint(6) unsigned NOT NULL DEFAULT '0',
  `art_up` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_hits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_hits_day` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_hits_week` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_hits_month` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_time` int(10) unsigned NOT NULL DEFAULT '0',
  `art_time_add` int(10) unsigned NOT NULL DEFAULT '0',
  `art_time_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `art_time_make` int(10) unsigned NOT NULL DEFAULT '0',
  `art_score` decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  `art_score_all` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_score_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `art_rel_art` varchar(255) NOT NULL DEFAULT '',
  `art_rel_vod` varchar(255) NOT NULL DEFAULT '',
  `art_pwd` varchar(10) NOT NULL DEFAULT '',
  `art_pwd_url` varchar(255) NOT NULL DEFAULT '',
  `art_title` mediumtext NOT NULL,
  `art_note` mediumtext NOT NULL,
  `art_content` mediumtext NOT NULL,
  PRIMARY KEY (`art_id`),
  KEY `type_id` (`type_id`) USING BTREE,
  KEY `type_id_1` (`type_id_1`) USING BTREE,
  KEY `art_level` (`art_level`) USING BTREE,
  KEY `art_hits` (`art_hits`) USING BTREE,
  KEY `art_time` (`art_time`) USING BTREE,
  KEY `art_letter` (`art_letter`) USING BTREE,
  KEY `art_down` (`art_down`) USING BTREE,
  KEY `art_up` (`art_up`) USING BTREE,
  KEY `art_tag` (`art_tag`) USING BTREE,
  KEY `art_name` (`art_name`) USING BTREE,
  KEY `art_enn` (`art_en`) USING BTREE,
  KEY `art_hits_day` (`art_hits_day`) USING BTREE,
  KEY `art_hits_week` (`art_hits_week`) USING BTREE,
  KEY `art_hits_month` (`art_hits_month`) USING BTREE,
  KEY `art_time_add` (`art_time_add`) USING BTREE,
  KEY `art_time_make` (`art_time_make`) USING BTREE,
  KEY `art_lock` (`art_lock`),
  KEY `art_score` (`art_score`),
  KEY `art_score_all` (`art_score_all`),
  KEY `art_score_num` (`art_score_num`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_art
-- ----------------------------

-- ----------------------------
-- Table structure for mac_card
-- ----------------------------
DROP TABLE IF EXISTS `mac_card`;
CREATE TABLE `mac_card` (
  `card_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `card_no` varchar(16) NOT NULL DEFAULT '',
  `card_pwd` varchar(8) NOT NULL DEFAULT '',
  `card_money` smallint(6) unsigned NOT NULL DEFAULT '0',
  `card_points` smallint(6) unsigned NOT NULL DEFAULT '0',
  `card_use_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `card_sale_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `card_add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `card_use_time` int(10) unsigned NOT NULL DEFAULT '0',
  `card_vip` int(10) unsigned NOT NULL,
  `card_tian` int(10) unsigned NOT NULL,
  PRIMARY KEY (`card_id`),
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `card_add_time` (`card_add_time`) USING BTREE,
  KEY `card_use_time` (`card_use_time`) USING BTREE,
  KEY `card_no` (`card_no`),
  KEY `card_pwd` (`card_pwd`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_card
-- ----------------------------

-- ----------------------------
-- Table structure for mac_carousel
-- ----------------------------
DROP TABLE IF EXISTS `mac_carousel`;
CREATE TABLE `mac_carousel` (
  `carousel_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `carousel_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `carousel_name` varchar(60) NOT NULL DEFAULT '',
  `carousel_sort` smallint(6) NOT NULL DEFAULT '0',
  `carousel_add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `carousel_time` int(10) unsigned NOT NULL DEFAULT '0',
  `carousel_url` varchar(255) NOT NULL DEFAULT '',
  `carousel_logo` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`carousel_id`),
  KEY `carousel_sort` (`carousel_sort`) USING BTREE,
  KEY `carousel_type` (`carousel_type`) USING BTREE,
  KEY `carousel_add_time` (`carousel_add_time`),
  KEY `carousel_time` (`carousel_time`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_carousel
-- ----------------------------
INSERT INTO `mac_carousel` VALUES ('4', '1', '轮播4', '0', '1662447901', '1662448462', 'https://baidu.com', 'https://api.modelym.com/images/117.png');
INSERT INTO `mac_carousel` VALUES ('5', '1', '轮播5', '0', '1662447942', '1662448467', 'https://baidu.com', 'https://api.modelym.com/images/9.png');
INSERT INTO `mac_carousel` VALUES ('6', '1', '轮播6', '0', '1662447974', '1662448400', 'https://baidu.com', 'https://api.modelym.com/images/166.png');

-- ----------------------------
-- Table structure for mac_cash
-- ----------------------------
DROP TABLE IF EXISTS `mac_cash`;
CREATE TABLE `mac_cash` (
  `cash_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `cash_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `cash_points` smallint(6) unsigned NOT NULL DEFAULT '0',
  `cash_money` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `cash_bank_name` varchar(60) NOT NULL DEFAULT '',
  `cash_bank_no` varchar(30) NOT NULL DEFAULT '',
  `cash_payee_name` varchar(30) NOT NULL DEFAULT '',
  `cash_time` int(10) unsigned NOT NULL DEFAULT '0',
  `cash_time_audit` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`cash_id`),
  KEY `user_id` (`user_id`),
  KEY `cash_status` (`cash_status`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_cash
-- ----------------------------

-- ----------------------------
-- Table structure for mac_cj_content
-- ----------------------------
DROP TABLE IF EXISTS `mac_cj_content`;
CREATE TABLE `mac_cj_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `nodeid` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `url` char(255) NOT NULL,
  `title` char(100) NOT NULL,
  `data` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `nodeid` (`nodeid`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mac_cj_content
-- ----------------------------

-- ----------------------------
-- Table structure for mac_cj_history
-- ----------------------------
DROP TABLE IF EXISTS `mac_cj_history`;
CREATE TABLE `mac_cj_history` (
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`md5`),
  KEY `md5` (`md5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_cj_history
-- ----------------------------

-- ----------------------------
-- Table structure for mac_cj_node
-- ----------------------------
DROP TABLE IF EXISTS `mac_cj_node`;
CREATE TABLE `mac_cj_node` (
  `nodeid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `lastdate` int(10) unsigned NOT NULL DEFAULT '0',
  `sourcecharset` varchar(8) NOT NULL,
  `sourcetype` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `urlpage` text NOT NULL,
  `pagesize_start` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `pagesize_end` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `page_base` char(255) NOT NULL,
  `par_num` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `url_contain` char(100) NOT NULL,
  `url_except` char(100) NOT NULL,
  `url_start` char(100) NOT NULL DEFAULT '',
  `url_end` char(100) NOT NULL DEFAULT '',
  `title_rule` char(100) NOT NULL,
  `title_html_rule` text NOT NULL,
  `type_rule` char(100) NOT NULL,
  `type_html_rule` text NOT NULL,
  `content_rule` char(100) NOT NULL,
  `content_html_rule` text NOT NULL,
  `content_page_start` char(100) NOT NULL,
  `content_page_end` char(100) NOT NULL,
  `content_page_rule` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `content_page` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `content_nextpage` char(100) NOT NULL,
  `down_attachment` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `watermark` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `coll_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `customize_config` text NOT NULL,
  `program_config` text NOT NULL,
  `mid` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`nodeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of mac_cj_node
-- ----------------------------

-- ----------------------------
-- Table structure for mac_collect
-- ----------------------------
DROP TABLE IF EXISTS `mac_collect`;
CREATE TABLE `mac_collect` (
  `collect_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `collect_name` varchar(30) NOT NULL DEFAULT '',
  `collect_url` varchar(255) NOT NULL DEFAULT '',
  `collect_type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `collect_mid` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `collect_appid` varchar(30) NOT NULL DEFAULT '',
  `collect_appkey` varchar(30) NOT NULL DEFAULT '',
  `collect_param` varchar(100) NOT NULL DEFAULT '',
  `collect_filter` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `collect_filter_from` varchar(255) NOT NULL DEFAULT '',
  `collect_opt` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `collect_sync_pic_opt` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '同步图片选项，0-跟随全局，1-开启，2-关闭',
  PRIMARY KEY (`collect_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_collect
-- ----------------------------
INSERT INTO `mac_collect` VALUES ('1', '细胞资源网', 'https://www.xxibaozyw.com/api.php/provide/vod/?ac=list', '2', '1', '', '', '', '0', '', '0', '0');

-- ----------------------------
-- Table structure for mac_comment
-- ----------------------------
DROP TABLE IF EXISTS `mac_comment`;
CREATE TABLE `mac_comment` (
  `comment_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment_mid` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `comment_rid` int(10) unsigned NOT NULL DEFAULT '0',
  `comment_pid` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `comment_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `comment_name` varchar(60) NOT NULL DEFAULT '',
  `comment_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `comment_time` int(10) unsigned NOT NULL DEFAULT '0',
  `comment_content` varchar(255) NOT NULL DEFAULT '',
  `comment_up` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comment_down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comment_reply` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comment_report` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `comment_mid` (`comment_mid`) USING BTREE,
  KEY `comment_rid` (`comment_rid`) USING BTREE,
  KEY `comment_time` (`comment_time`) USING BTREE,
  KEY `comment_pid` (`comment_pid`),
  KEY `user_id` (`user_id`),
  KEY `comment_reply` (`comment_reply`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_comment
-- ----------------------------

-- ----------------------------
-- Table structure for mac_gbook
-- ----------------------------
DROP TABLE IF EXISTS `mac_gbook`;
CREATE TABLE `mac_gbook` (
  `gbook_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gbook_rid` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `gbook_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `gbook_name` varchar(60) NOT NULL DEFAULT '',
  `gbook_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `gbook_time` int(10) unsigned NOT NULL DEFAULT '0',
  `gbook_reply_time` int(10) unsigned NOT NULL DEFAULT '0',
  `gbook_content` varchar(255) NOT NULL DEFAULT '',
  `gbook_reply` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`gbook_id`),
  KEY `gbook_rid` (`gbook_rid`) USING BTREE,
  KEY `gbook_time` (`gbook_time`) USING BTREE,
  KEY `gbook_reply_time` (`gbook_reply_time`) USING BTREE,
  KEY `user_id` (`user_id`),
  KEY `gbook_reply` (`gbook_reply`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_gbook
-- ----------------------------

-- ----------------------------
-- Table structure for mac_group
-- ----------------------------
DROP TABLE IF EXISTS `mac_group`;
CREATE TABLE `mac_group` (
  `group_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(30) NOT NULL DEFAULT '',
  `group_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `group_type` text NOT NULL,
  `group_popedom` text NOT NULL,
  `group_points_day` smallint(6) unsigned NOT NULL DEFAULT '0',
  `group_points_week` smallint(6) NOT NULL DEFAULT '0',
  `group_points_month` smallint(6) unsigned NOT NULL DEFAULT '0',
  `group_points_year` smallint(6) unsigned NOT NULL DEFAULT '0',
  `group_points_free` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`group_id`),
  KEY `group_status` (`group_status`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_group
-- ----------------------------
INSERT INTO `mac_group` VALUES ('1', '游客', '1', ',1,6,7,8,9,10,11,12,2,13,14,15,16,3,4,5,17,18,', '{\"1\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"6\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"7\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"8\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"9\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"10\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"11\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"12\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"2\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"13\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"14\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"15\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"16\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"3\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"4\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"5\":{\"1\":\"1\",\"2\":\"2\"},\"17\":{\"1\":\"1\",\"2\":\"2\"},\"18\":{\"1\":\"1\",\"2\":\"2\"}}', '0', '0', '0', '0', '0');
INSERT INTO `mac_group` VALUES ('2', '默认会员', '1', ',1,6,7,8,9,10,11,12,2,13,14,15,16,3,4,5,17,18,', '{\"1\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"6\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"7\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"8\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"9\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"10\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"11\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"12\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"2\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"13\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"14\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"15\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"16\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"3\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"4\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"5\":{\"1\":\"1\",\"2\":\"2\"},\"17\":{\"1\":\"1\",\"2\":\"2\"},\"18\":{\"1\":\"1\",\"2\":\"2\"}}', '0', '0', '0', '0', '0');
INSERT INTO `mac_group` VALUES ('3', 'VIP会员', '1', ',1,6,7,8,9,10,11,12,2,13,14,15,16,3,4,5,17,18,', '{\"1\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"6\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"7\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"8\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"9\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"10\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"11\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"12\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"2\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"13\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"14\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"15\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"16\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"3\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"4\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\"},\"5\":{\"1\":\"1\",\"2\":\"2\"},\"17\":{\"1\":\"1\",\"2\":\"2\"},\"18\":{\"1\":\"1\",\"2\":\"2\"}}', '10', '70', '300', '3600', '0');

-- ----------------------------
-- Table structure for mac_link
-- ----------------------------
DROP TABLE IF EXISTS `mac_link`;
CREATE TABLE `mac_link` (
  `link_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `link_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `link_name` varchar(60) NOT NULL DEFAULT '',
  `link_sort` smallint(6) NOT NULL DEFAULT '0',
  `link_add_time` int(10) unsigned NOT NULL DEFAULT '0',
  `link_time` int(10) unsigned NOT NULL DEFAULT '0',
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_logo` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_sort` (`link_sort`) USING BTREE,
  KEY `link_type` (`link_type`) USING BTREE,
  KEY `link_add_time` (`link_add_time`),
  KEY `link_time` (`link_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_link
-- ----------------------------

-- ----------------------------
-- Table structure for mac_msg
-- ----------------------------
DROP TABLE IF EXISTS `mac_msg`;
CREATE TABLE `mac_msg` (
  `msg_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `msg_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `msg_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `msg_to` varchar(30) NOT NULL DEFAULT '',
  `msg_code` varchar(10) NOT NULL DEFAULT '',
  `msg_content` varchar(255) NOT NULL DEFAULT '',
  `msg_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`msg_id`),
  KEY `msg_code` (`msg_code`),
  KEY `msg_time` (`msg_time`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_msg
-- ----------------------------

-- ----------------------------
-- Table structure for mac_order
-- ----------------------------
DROP TABLE IF EXISTS `mac_order`;
CREATE TABLE `mac_order` (
  `order_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `order_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `order_code` varchar(30) NOT NULL DEFAULT '',
  `order_group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `order_price` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `order_time` int(10) unsigned NOT NULL DEFAULT '0',
  `order_points` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `order_pay_type` varchar(10) NOT NULL DEFAULT '',
  `order_pay_time` int(10) unsigned NOT NULL DEFAULT '0',
  `order_remarks` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`order_id`),
  KEY `order_code` (`order_code`) USING BTREE,
  KEY `user_id` (`user_id`) USING BTREE,
  KEY `order_time` (`order_time`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_order
-- ----------------------------

-- ----------------------------
-- Table structure for mac_plog
-- ----------------------------
DROP TABLE IF EXISTS `mac_plog`;
CREATE TABLE `mac_plog` (
  `plog_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id_1` int(10) NOT NULL DEFAULT '0',
  `plog_type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `plog_points` smallint(6) unsigned NOT NULL DEFAULT '0',
  `plog_time` int(10) unsigned NOT NULL DEFAULT '0',
  `plog_remarks` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`plog_id`),
  KEY `user_id` (`user_id`),
  KEY `plog_type` (`plog_type`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_plog
-- ----------------------------

-- ----------------------------
-- Table structure for mac_role
-- ----------------------------
DROP TABLE IF EXISTS `mac_role`;
CREATE TABLE `mac_role` (
  `role_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_rid` int(10) unsigned NOT NULL DEFAULT '0',
  `role_name` varchar(255) NOT NULL DEFAULT '',
  `role_en` varchar(255) NOT NULL DEFAULT '',
  `role_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `role_lock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `role_letter` char(1) NOT NULL DEFAULT '',
  `role_color` varchar(6) NOT NULL DEFAULT '',
  `role_actor` varchar(255) NOT NULL DEFAULT '',
  `role_remarks` varchar(100) NOT NULL DEFAULT '',
  `role_pic` varchar(1024) NOT NULL DEFAULT '',
  `role_sort` smallint(6) unsigned NOT NULL DEFAULT '0',
  `role_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `role_time` int(10) unsigned NOT NULL DEFAULT '0',
  `role_time_add` int(10) unsigned NOT NULL DEFAULT '0',
  `role_time_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `role_time_make` int(10) unsigned NOT NULL DEFAULT '0',
  `role_hits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_hits_day` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_hits_week` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_hits_month` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_score` decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  `role_score_all` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_score_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_up` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `role_tpl` varchar(30) NOT NULL DEFAULT '',
  `role_jumpurl` varchar(150) NOT NULL DEFAULT '',
  `role_content` text NOT NULL,
  PRIMARY KEY (`role_id`),
  KEY `role_rid` (`role_rid`),
  KEY `role_name` (`role_name`),
  KEY `role_en` (`role_en`),
  KEY `role_letter` (`role_letter`),
  KEY `role_actor` (`role_actor`),
  KEY `role_level` (`role_level`),
  KEY `role_time` (`role_time`),
  KEY `role_time_add` (`role_time_add`),
  KEY `role_score` (`role_score`),
  KEY `role_score_all` (`role_score_all`),
  KEY `role_score_num` (`role_score_num`),
  KEY `role_up` (`role_up`),
  KEY `role_down` (`role_down`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_role
-- ----------------------------

-- ----------------------------
-- Table structure for mac_topic
-- ----------------------------
DROP TABLE IF EXISTS `mac_topic`;
CREATE TABLE `mac_topic` (
  `topic_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `topic_name` varchar(255) NOT NULL DEFAULT '',
  `topic_en` varchar(255) NOT NULL DEFAULT '',
  `topic_sub` varchar(255) NOT NULL DEFAULT '',
  `topic_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `topic_sort` smallint(6) unsigned NOT NULL DEFAULT '0',
  `topic_letter` char(1) NOT NULL DEFAULT '',
  `topic_color` varchar(6) NOT NULL DEFAULT '',
  `topic_tpl` varchar(30) NOT NULL DEFAULT '',
  `topic_type` varchar(255) NOT NULL DEFAULT '',
  `topic_pic` varchar(1024) NOT NULL DEFAULT '',
  `topic_pic_thumb` varchar(1024) NOT NULL DEFAULT '',
  `topic_pic_slide` varchar(1024) NOT NULL DEFAULT '',
  `topic_key` varchar(255) NOT NULL DEFAULT '',
  `topic_des` varchar(255) NOT NULL DEFAULT '',
  `topic_title` varchar(255) NOT NULL DEFAULT '',
  `topic_blurb` varchar(255) NOT NULL DEFAULT '',
  `topic_remarks` varchar(100) NOT NULL DEFAULT '',
  `topic_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `topic_up` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_score` decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  `topic_score_all` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_score_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_hits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_hits_day` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_hits_week` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_hits_month` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `topic_time` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_time_add` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_time_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_time_make` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_tag` varchar(255) NOT NULL DEFAULT '',
  `topic_rel_vod` text NOT NULL,
  `topic_rel_art` text NOT NULL,
  `topic_content` text NOT NULL,
  `topic_extend` text NOT NULL,
  PRIMARY KEY (`topic_id`),
  KEY `topic_sort` (`topic_sort`) USING BTREE,
  KEY `topic_level` (`topic_level`) USING BTREE,
  KEY `topic_score` (`topic_score`) USING BTREE,
  KEY `topic_score_all` (`topic_score_all`) USING BTREE,
  KEY `topic_score_num` (`topic_score_num`) USING BTREE,
  KEY `topic_hits` (`topic_hits`) USING BTREE,
  KEY `topic_hits_day` (`topic_hits_day`) USING BTREE,
  KEY `topic_hits_week` (`topic_hits_week`) USING BTREE,
  KEY `topic_hits_month` (`topic_hits_month`) USING BTREE,
  KEY `topic_time_add` (`topic_time_add`) USING BTREE,
  KEY `topic_time` (`topic_time`) USING BTREE,
  KEY `topic_time_hits` (`topic_time_hits`) USING BTREE,
  KEY `topic_name` (`topic_name`),
  KEY `topic_en` (`topic_en`),
  KEY `topic_up` (`topic_up`),
  KEY `topic_down` (`topic_down`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_topic
-- ----------------------------
INSERT INTO `mac_topic` VALUES ('1', '测试专题1', 'ceshizhuanti1', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/117.png', '', '', '', '', '', '测试专题1简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043126', '1640880363', '0', '0', '', '177,176,175,174,173,172,171,170,169,168,167,166,165,164,163,162,161,160,159,158', '', '', '');
INSERT INTO `mac_topic` VALUES ('2', '测试专题2', 'ceshizhuanti2', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/167.png', '', '', '', '', '', '测试专题2简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043379', '1640880406', '0', '0', '', '21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40', '', '', '');
INSERT INTO `mac_topic` VALUES ('3', '测试专题3', 'ceshizhuanti3', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/132.png', '', '', '', '', '', '测试专题3简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043450', '1640881579', '0', '0', '', '41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60', '', '', '');
INSERT INTO `mac_topic` VALUES ('4', '测试专题4', 'ceshizhuanti4', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/133.png', '', '', '', '', '', '测试专题4简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043473', '1640881599', '0', '0', '', '61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80', '', '', '');
INSERT INTO `mac_topic` VALUES ('5', '测试专题5', 'ceshizhuanti5', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/90.png', '', '', '', '', '', '测试专题5简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043610', '1640881621', '0', '0', '', '81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100', '', '', '');
INSERT INTO `mac_topic` VALUES ('6', '测试专题6', 'ceshizhuanti6', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/88.png', '', '', '', '', '', '测试专题6简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043687', '1640881643', '0', '0', '', '101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120', '', '', '');
INSERT INTO `mac_topic` VALUES ('7', '测试专题7', 'ceshizhuanti7', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/56.png', '', '', '', '', '', '测试专题7简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043719', '1640881662', '0', '0', '', '121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140', '', '', '');
INSERT INTO `mac_topic` VALUES ('8', '测试专题8', 'ceshizhuanti8', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/43.png', '', '', '', '', '', '测试专题8简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043770', '1640881680', '0', '0', '', '141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160', '', '', '');
INSERT INTO `mac_topic` VALUES ('9', '测试专题9', 'ceshizhuanti9', '', '1', '0', '', '', 'detail.html', '', 'https://api.modelym.com/images/118.png', '', '', '', '', '', '测试专题9简介内容文字', '', '0', '0', '0', '0.0', '0', '0', '0', '0', '0', '0', '1641043812', '1640881696', '0', '0', '', '161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177', '', '', '');

-- ----------------------------
-- Table structure for mac_type
-- ----------------------------
DROP TABLE IF EXISTS `mac_type`;
CREATE TABLE `mac_type` (
  `type_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(60) NOT NULL DEFAULT '',
  `type_en` varchar(60) NOT NULL DEFAULT '',
  `type_sort` smallint(6) unsigned NOT NULL DEFAULT '0',
  `type_mid` smallint(6) unsigned NOT NULL DEFAULT '1',
  `type_pid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `type_status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `type_tpl` varchar(30) NOT NULL DEFAULT '',
  `type_tpl_list` varchar(30) NOT NULL DEFAULT '',
  `type_tpl_detail` varchar(30) NOT NULL DEFAULT '',
  `type_tpl_play` varchar(30) NOT NULL DEFAULT '',
  `type_tpl_down` varchar(30) NOT NULL DEFAULT '',
  `type_key` varchar(255) NOT NULL DEFAULT '',
  `type_des` varchar(255) NOT NULL DEFAULT '',
  `type_title` varchar(255) NOT NULL DEFAULT '',
  `type_union` varchar(255) NOT NULL DEFAULT '',
  `type_extend` text NOT NULL,
  `type_logo` varchar(255) NOT NULL DEFAULT '',
  `type_pic` varchar(1024) NOT NULL DEFAULT '',
  `type_jumpurl` varchar(150) NOT NULL DEFAULT '',
  PRIMARY KEY (`type_id`),
  KEY `type_sort` (`type_sort`) USING BTREE,
  KEY `type_pid` (`type_pid`) USING BTREE,
  KEY `type_name` (`type_name`),
  KEY `type_en` (`type_en`),
  KEY `type_mid` (`type_mid`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_type
-- ----------------------------
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (1, '热门视频', 'fenlei1', 1, 1, 0, 1, 'type.html', 'show.html', 'detail.html', 'play.html', 'down.html', '', '', '', '', '{"class":"\\u559c\\u5267,\\u7231\\u60c5,\\u6050\\u6016,\\u52a8\\u4f5c,\\u79d1\\u5e7b,\\u5267\\u60c5,\\u6218\\u4e89,\\u8b66\\u532a,\\u72af\\u7f6a,\\u52a8\\u753b,\\u5947\\u5e7b,\\u6b66\\u4fa0,\\u5192\\u9669,\\u67aa\\u6218,\\u6050\\u6016,\\u60ac\\u7591,\\u60ca\\u609a,\\u7ecf\\u5178,\\u9752\\u6625,\\u6587\\u827a,\\u5fae\\u7535\\u5f71,\\u53e4\\u88c5,\\u5386\\u53f2,\\u8fd0\\u52a8,\\u519c\\u6751,\\u513f\\u7ae5,\\u7f51\\u7edc\\u7535\\u5f71","area":"\\u5927\\u9646,\\u9999\\u6e2f,\\u53f0\\u6e7e,\\u7f8e\\u56fd,\\u6cd5\\u56fd,\\u82f1\\u56fd,\\u65e5\\u672c,\\u97e9\\u56fd,\\u5fb7\\u56fd,\\u6cf0\\u56fd,\\u5370\\u5ea6,\\u610f\\u5927\\u5229,\\u897f\\u73ed\\u7259,\\u52a0\\u62ff\\u5927,\\u5176\\u4ed6","lang":"\\u56fd\\u8bed,\\u82f1\\u8bed,\\u7ca4\\u8bed,\\u95fd\\u5357\\u8bed,\\u97e9\\u8bed,\\u65e5\\u8bed,\\u6cd5\\u8bed,\\u5fb7\\u8bed,\\u5176\\u5b83","year":"2018,2017,2016,2015,2014,2013,2012,2011,2010","star":"\\u738b\\u5b9d\\u5f3a,\\u9ec4\\u6e24,\\u5468\\u8fc5,\\u5468\\u51ac\\u96e8,\\u8303\\u51b0\\u51b0,\\u9648\\u5b66\\u51ac,\\u9648\\u4f1f\\u9706,\\u90ed\\u91c7\\u6d01,\\u9093\\u8d85,\\u6210\\u9f99,\\u845b\\u4f18,\\u6797\\u6b63\\u82f1,\\u5f20\\u5bb6\\u8f89,\\u6881\\u671d\\u4f1f,\\u5f90\\u5ce5,\\u90d1\\u607a,\\u5434\\u5f66\\u7956,\\u5218\\u5fb7\\u534e,\\u5468\\u661f\\u9a70,\\u6797\\u9752\\u971e,\\u5468\\u6da6\\u53d1,\\u674e\\u8fde\\u6770,\\u7504\\u5b50\\u4e39,\\u53e4\\u5929\\u4e50,\\u6d2a\\u91d1\\u5b9d,\\u59da\\u6668,\\u502a\\u59ae,\\u9ec4\\u6653\\u660e,\\u5f6d\\u4e8e\\u664f,\\u6c64\\u552f,\\u9648\\u5c0f\\u6625","director":"\\u51af\\u5c0f\\u521a,\\u5f20\\u827a\\u8c0b,\\u5434\\u5b87\\u68ee,\\u9648\\u51ef\\u6b4c,\\u5f90\\u514b,\\u738b\\u5bb6\\u536b,\\u59dc\\u6587,\\u5468\\u661f\\u9a70,\\u674e\\u5b89","state":"\\u6b63\\u7247,\\u9884\\u544a\\u7247,\\u82b1\\u7d6e","version":"\\u9ad8\\u6e05\\u7248,\\u5267\\u573a\\u7248,\\u62a2\\u5148\\u7248,OVA,TV,\\u5f71\\u9662\\u7248"}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (35, '国产直播', 'guochanzhibo', 0, 1, 26, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (36, '岛国群交', 'daoguoqunjiao', 0, 1, 26, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (37, '日本有码', 'guochanseqing', 4, 1, 1, 1, 'type.html', 'show.html', 'detail.html', 'play.html', 'down.html', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (27, '乱伦中出', 'caiyizhibo', 0, 1, 26, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (28, '传媒原创', 'chuanmeiyuanchuang', 0, 1, 26, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (29, '口爆颜射', 'koubaoyanshe', 0, 1, 26, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (41, '角色扮演', 'juesebanyan', 2, 1, 34, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (22, '黑人洋屌', 'ribenwuma', 5, 1, 20, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (23, '欧美精品', 'oumeijingpin', 1, 1, 20, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (24, '卡通动漫', 'katongdongman', 10, 1, 20, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (26, '视频二区', 'shipinerqu', 3, 1, 0, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (7, '日本无码', 'zilei2', 2, 1, 1, 1, 'type.html', 'show.html', 'detail.html', 'play.html', 'down.html', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (6, '国产色情', 'zilei1', 1, 1, 1, 1, 'type.html', 'show.html', 'detail.html', 'play.html', 'down.html', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (8, '自拍偷拍', 'zilei3', 3, 1, 1, 1, 'type.html', 'show.html', 'detail.html', 'play.html', 'down.html', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (39, '岛国素人', 'daoguosuren', 5, 1, 34, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (34, '视频三区', 'shipinsanqu', 4, 1, 0, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (33, '重口调教', 'zhongkoudiaojiao', 5, 1, 34, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (32, '萝莉少女', 'luolishaonv', 0, 1, 34, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (31, '岛国女优', 'daoguonvyou', 3, 1, 34, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (21, '人妻熟女', 'zipaitoupai', 4, 1, 20, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (20, '视频一区', 'shipinyiqu', 2, 1, 0, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (38, '中文字幕', 'zhongwenzimu', 0, 1, 1, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (40, '吃瓜爆料', 'chiguabaoliao', 2, 1, 20, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (42, '淫娃自慰', 'yinwaziwei', 6, 1, 34, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (43, '视频四区', 'shipinsiqu', 5, 1, 0, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (44, '公开漏出', 'gongkailouchu', 5, 1, 43, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (45, '韩国直播', 'hanguozhibo', 1, 1, 43, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (46, '户外打野', 'huwaidaye', 3, 1, 43, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (47, '高潮喷水', 'gaochaopenshui', 6, 1, 43, 1, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');
INSERT INTO `mac_type` (type_id, type_name, type_en, type_sort, type_mid, type_pid, type_status, type_tpl, type_tpl_list, type_tpl_detail, type_tpl_play, type_tpl_down, type_key, type_des, type_title, type_union, type_extend, type_logo, type_pic, type_jumpurl) VALUES (48, '电车痴汉', 'dianchechihan', 1, 1, 43, 0, 'type.html', 'show.html', 'detail.html', '', '', '', '', '', '', '{"class":"","area":"","lang":"","year":"","star":"","director":"","state":"","version":""}', '', '', '');

-- ----------------------------
-- Table structure for mac_ulog
-- ----------------------------
DROP TABLE IF EXISTS `mac_ulog`;
CREATE TABLE `mac_ulog` (
  `ulog_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ulog_mid` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ulog_type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ulog_rid` int(10) unsigned NOT NULL DEFAULT '0',
  `ulog_sid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ulog_nid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `ulog_points` smallint(6) unsigned NOT NULL DEFAULT '0',
  `ulog_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ulog_id`),
  KEY `user_id` (`user_id`),
  KEY `ulog_mid` (`ulog_mid`),
  KEY `ulog_type` (`ulog_type`),
  KEY `ulog_rid` (`ulog_rid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_ulog
-- ----------------------------

-- ----------------------------
-- Table structure for mac_user
-- ----------------------------
DROP TABLE IF EXISTS `mac_user`;
CREATE TABLE `mac_user` (
  `user_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `user_name` varchar(30) NOT NULL DEFAULT '',
  `user_pwd` varchar(32) NOT NULL DEFAULT '',
  `user_nick_name` varchar(30) NOT NULL DEFAULT '',
  `user_qq` varchar(16) NOT NULL DEFAULT '',
  `user_email` varchar(30) NOT NULL DEFAULT '',
  `user_phone` varchar(16) NOT NULL DEFAULT '',
  `user_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_portrait` varchar(100) NOT NULL DEFAULT '',
  `user_portrait_thumb` varchar(100) NOT NULL DEFAULT '',
  `user_openid_qq` varchar(40) NOT NULL DEFAULT '',
  `user_openid_weixin` varchar(40) NOT NULL DEFAULT '',
  `user_question` varchar(255) NOT NULL DEFAULT '',
  `user_answer` varchar(255) NOT NULL DEFAULT '',
  `user_points` int(10) unsigned NOT NULL DEFAULT '0',
  `user_points_froze` int(10) unsigned NOT NULL DEFAULT '0',
  `user_reg_time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_reg_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `user_login_time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_login_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `user_last_login_time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_last_login_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `user_login_num` smallint(6) unsigned NOT NULL DEFAULT '0',
  `user_extend` smallint(6) unsigned NOT NULL DEFAULT '0',
  `user_random` varchar(32) NOT NULL DEFAULT '',
  `user_end_time` int(10) unsigned NOT NULL DEFAULT '0',
  `user_pid` int(10) unsigned NOT NULL DEFAULT '0',
  `user_pid_2` int(10) unsigned NOT NULL DEFAULT '0',
  `user_pid_3` int(10) unsigned NOT NULL DEFAULT '0',
  `user_codes` varchar(255) DEFAULT NULL COMMENT '0',
  PRIMARY KEY (`user_id`),
  KEY `type_id` (`group_id`) USING BTREE,
  KEY `user_name` (`user_name`),
  KEY `user_reg_time` (`user_reg_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_user
-- ----------------------------

-- ----------------------------
-- Table structure for mac_visit
-- ----------------------------
DROP TABLE IF EXISTS `mac_visit`;
CREATE TABLE `mac_visit` (
  `visit_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT '0',
  `visit_ip` int(10) unsigned NOT NULL DEFAULT '0',
  `visit_ly` varchar(100) NOT NULL DEFAULT '',
  `visit_time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`visit_id`),
  KEY `user_id` (`user_id`),
  KEY `visit_time` (`visit_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_visit
-- ----------------------------

-- ----------------------------
-- Table structure for mac_vod
-- ----------------------------
DROP TABLE IF EXISTS `mac_vod`;
CREATE TABLE `mac_vod` (
  `vod_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` smallint(6) NOT NULL DEFAULT '0',
  `type_id_1` smallint(6) unsigned NOT NULL DEFAULT '0',
  `group_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  `vod_name` varchar(255) NOT NULL DEFAULT '',
  `vod_sub` varchar(255) NOT NULL DEFAULT '',
  `vod_en` varchar(255) NOT NULL DEFAULT '',
  `vod_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vod_letter` char(1) NOT NULL DEFAULT '',
  `vod_color` varchar(6) NOT NULL DEFAULT '',
  `vod_tag` varchar(100) NOT NULL DEFAULT '',
  `vod_class` varchar(255) NOT NULL DEFAULT '',
  `vod_pic` varchar(1024) NOT NULL DEFAULT '',
  `vod_pic_thumb` varchar(1024) NOT NULL DEFAULT '',
  `vod_pic_slide` varchar(1024) NOT NULL DEFAULT '',
  `vod_pic_screenshot` text,
  `vod_actor` varchar(255) NOT NULL DEFAULT '',
  `vod_director` varchar(255) NOT NULL DEFAULT '',
  `vod_writer` varchar(100) NOT NULL DEFAULT '',
  `vod_behind` varchar(100) NOT NULL DEFAULT '',
  `vod_blurb` varchar(255) NOT NULL DEFAULT '',
  `vod_remarks` varchar(100) NOT NULL DEFAULT '',
  `vod_pubdate` varchar(100) NOT NULL DEFAULT '',
  `vod_total` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_serial` varchar(20) NOT NULL DEFAULT '0',
  `vod_tv` varchar(30) NOT NULL DEFAULT '',
  `vod_weekday` varchar(30) NOT NULL DEFAULT '',
  `vod_area` varchar(20) NOT NULL DEFAULT '',
  `vod_lang` varchar(10) NOT NULL DEFAULT '',
  `vod_year` varchar(10) NOT NULL DEFAULT '',
  `vod_version` varchar(30) NOT NULL DEFAULT '',
  `vod_state` varchar(30) NOT NULL DEFAULT '',
  `vod_author` varchar(60) NOT NULL DEFAULT '',
  `vod_jumpurl` varchar(150) NOT NULL DEFAULT '',
  `vod_tpl` varchar(30) NOT NULL DEFAULT '',
  `vod_tpl_play` varchar(30) NOT NULL DEFAULT '',
  `vod_tpl_down` varchar(30) NOT NULL DEFAULT '',
  `vod_isend` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vod_lock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vod_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vod_vip` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `vod_copyright` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vod_points` smallint(6) unsigned NOT NULL DEFAULT '0',
  `vod_points_play` smallint(6) unsigned NOT NULL DEFAULT '0',
  `vod_points_down` smallint(6) unsigned NOT NULL DEFAULT '0',
  `vod_hits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_hits_day` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_hits_week` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_hits_month` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_duration` varchar(10) NOT NULL DEFAULT '',
  `vod_up` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_score` decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  `vod_score_all` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_score_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `vod_time` int(10) unsigned NOT NULL DEFAULT '0',
  `vod_time_add` int(10) unsigned NOT NULL DEFAULT '0',
  `vod_time_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `vod_time_make` int(10) unsigned NOT NULL DEFAULT '0',
  `vod_trysee` smallint(6) unsigned NOT NULL DEFAULT '0',
  `vod_douban_id` int(10) unsigned NOT NULL DEFAULT '0',
  `vod_douban_score` decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  `vod_reurl` varchar(255) NOT NULL DEFAULT '',
  `vod_rel_vod` varchar(255) NOT NULL DEFAULT '',
  `vod_rel_art` varchar(255) NOT NULL DEFAULT '',
  `vod_pwd` varchar(10) NOT NULL DEFAULT '',
  `vod_pwd_url` varchar(255) NOT NULL DEFAULT '',
  `vod_pwd_play` varchar(10) NOT NULL DEFAULT '',
  `vod_pwd_play_url` varchar(255) NOT NULL DEFAULT '',
  `vod_pwd_down` varchar(10) NOT NULL DEFAULT '',
  `vod_pwd_down_url` varchar(255) NOT NULL DEFAULT '',
  `vod_content` mediumtext NOT NULL,
  `vod_play_from` varchar(255) NOT NULL DEFAULT '',
  `vod_play_server` varchar(255) NOT NULL DEFAULT '',
  `vod_play_note` varchar(255) NOT NULL DEFAULT '',
  `vod_play_url` mediumtext NOT NULL,
  `vod_down_from` varchar(255) NOT NULL DEFAULT '',
  `vod_down_server` varchar(255) NOT NULL DEFAULT '',
  `vod_down_note` varchar(255) NOT NULL DEFAULT '',
  `vod_down_url` mediumtext NOT NULL,
  `vod_plot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vod_plot_name` mediumtext NOT NULL,
  `vod_plot_detail` mediumtext NOT NULL,
  PRIMARY KEY (`vod_id`),
  KEY `type_id` (`type_id`) USING BTREE,
  KEY `type_id_1` (`type_id_1`) USING BTREE,
  KEY `vod_level` (`vod_level`) USING BTREE,
  KEY `vod_hits` (`vod_hits`) USING BTREE,
  KEY `vod_letter` (`vod_letter`) USING BTREE,
  KEY `vod_name` (`vod_name`) USING BTREE,
  KEY `vod_year` (`vod_year`) USING BTREE,
  KEY `vod_area` (`vod_area`) USING BTREE,
  KEY `vod_lang` (`vod_lang`) USING BTREE,
  KEY `vod_tag` (`vod_tag`) USING BTREE,
  KEY `vod_class` (`vod_class`) USING BTREE,
  KEY `vod_lock` (`vod_lock`) USING BTREE,
  KEY `vod_up` (`vod_up`) USING BTREE,
  KEY `vod_down` (`vod_down`) USING BTREE,
  KEY `vod_en` (`vod_en`) USING BTREE,
  KEY `vod_hits_day` (`vod_hits_day`) USING BTREE,
  KEY `vod_hits_week` (`vod_hits_week`) USING BTREE,
  KEY `vod_hits_month` (`vod_hits_month`) USING BTREE,
  KEY `vod_plot` (`vod_plot`) USING BTREE,
  KEY `vod_points_play` (`vod_points_play`) USING BTREE,
  KEY `vod_points_down` (`vod_points_down`) USING BTREE,
  KEY `group_id` (`group_id`) USING BTREE,
  KEY `vod_time_add` (`vod_time_add`) USING BTREE,
  KEY `vod_time` (`vod_time`) USING BTREE,
  KEY `vod_time_make` (`vod_time_make`) USING BTREE,
  KEY `vod_actor` (`vod_actor`) USING BTREE,
  KEY `vod_director` (`vod_director`) USING BTREE,
  KEY `vod_score_all` (`vod_score_all`) USING BTREE,
  KEY `vod_score_num` (`vod_score_num`) USING BTREE,
  KEY `vod_total` (`vod_total`) USING BTREE,
  KEY `vod_score` (`vod_score`) USING BTREE,
  KEY `vod_version` (`vod_version`),
  KEY `vod_state` (`vod_state`),
  KEY `vod_isend` (`vod_isend`)
) ENGINE=MyISAM AUTO_INCREMENT=327 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_vod
-- ----------------------------
INSERT INTO `mac_vod` VALUES ('326', '38', '0', '0', 'NBES-058 重印版感恩節價格 1980 日元我在偷偷操她媽媽……小早川玲子 - 小早川怜子', '', 'NBES058zhongyinbanganenjiejiage1980riyuanwozaitoutoucaotamamaxiaozaochuanlingzixiaozaochuanlianzi', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/16264_cover_2025-02-22_121110.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/16264_cover_2025-02-22_121110.jpg', '', '', '', '', 'NBES-058 重印版感恩節價格 1980 日元我在偷偷操她媽媽……小早川玲子 - 小早川怜子', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '145', '133', '118', '413', '', '844', '336', '7.0', '3465', '495', '1740423658', '1740337595', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NBES-058 重印版感恩節價格 1980 日元我在偷偷操她媽媽……小早川玲子 - 小早川怜子', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9c30e7c294e7/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('325', '38', '0', '0', 'VENX-192 「阿姨的內褲心動了嗎？」剛脫下內褲榨取侄子每一滴精液的正田千里阿姨 - 翔田千里', '', 'VENX192ayideneikuxindongliaomagangtuoxianeikuzhaquzhizimeiyidijingyedezhengtianqianliayixiangtianqianli', '1', 'V', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/74102_cover_2025-02-22_121110.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/74102_cover_2025-02-22_121110.jpg', '', '', '', '', 'VENX-192 「阿姨的內褲心動了嗎？」剛脫下內褲榨取侄子每一滴精液的正田千里阿姨 - 翔田千里', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '598', '107', '240', '452', '', '498', '919', '7.0', '4081', '583', '1740423658', '1740338135', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'VENX-192 「阿姨的內褲心動了嗎？」剛脫下內褲榨取侄子每一滴精液的正田千里阿姨 - 翔田千里', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/6a2d0064d834/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('324', '38', '0', '0', 'ABW-313 從下面的絕對凝視款待冬宮美麗的小町流川優 23 - 流川夕', '', 'ABW313congxiamiandejueduiningshikuandaidonggongmeilidexiaotingliuchuanyou23liuchuanxi', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/10534_cover_2025-02-22_115309.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/10534_cover_2025-02-22_115309.jpg', '', '', '', '', 'ABW-313 從下面的絕對凝視款待冬宮美麗的小町流川優 23 - 流川夕', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '861', '233', '820', '165', '', '307', '651', '6.0', '4200', '700', '1740423658', '1740338675', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ABW-313 從下面的絕對凝視款待冬宮美麗的小町流川優 23 - 流川夕', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/522dd65f514b/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('323', '38', '0', '0', 'VEC-568 我只是想為我丈夫的人妻性慾奶油餡餅沙龍乾淨，她的美乳和陰道被黏糊糊的按摩摸索著，', '', 'VEC568wozhishixiangweiwozhangfuderenqixingyunaiyouxianbingshalongqianjingtademeiruheyindaobeinianhuhudeanmomosuozhu', '1', 'V', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/89839_cover_2025-02-22_121110.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/89839_cover_2025-02-22_121110.jpg', '', '', '', '', 'VEC-568 我只是想為我丈夫的人妻性慾奶油餡餅沙龍乾淨，她的美乳和陰道被黏糊糊的按摩摸索著，', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '962', '880', '225', '949', '', '261', '606', '2.0', '668', '334', '1740423658', '1740339215', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'VEC-568 我只是想為我丈夫的人妻性慾奶油餡餅沙龍乾淨，她的美乳和陰道被黏糊糊的按摩摸索著，', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/54d29bb7fd32/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('322', '38', '0', '0', 'HZGD-236 天天干打工美巨乳苗條人妻…去年夏天的汗流浹背的禁忌姦淫。平野葵 - 平野蒼', '', 'HZGD236tiantiangandagongmeijurumiaotiaorenqiqunianxiatiandehanliujiabeidejinjijianyinpingyekuipingyecang', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/99249_cover_2025-02-22_122941.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/99249_cover_2025-02-22_122941.jpg', '', '', '', '', 'HZGD-236 天天干打工美巨乳苗條人妻…去年夏天的汗流浹背的禁忌姦淫。平野葵 - 平野蒼', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '693', '686', '511', '780', '', '746', '476', '3.0', '2955', '985', '1740423657', '1740339755', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HZGD-236 天天干打工美巨乳苗條人妻…去年夏天的汗流浹背的禁忌姦淫。平野葵 - 平野蒼', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/c098a9deff8a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('321', '38', '0', '0', 'ABW-312 永無止境的陰道射精性愛。 15 連續陰道射精七島麻衣 - 七嶋舞', '', 'ABW312yongwuzhijingdeyindaoshejingxingai15lianxuyindaoshejingqidaomayiqidaowu', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/38284_cover_2025-02-22_115309.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/38284_cover_2025-02-22_115309.jpg', '', '', '', '', 'ABW-312 永無止境的陰道射精性愛。 15 連續陰道射精七島麻衣 - 七嶋舞', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '503', '209', '636', '112', '', '357', '984', '2.0', '372', '186', '1740423657', '1740340355', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ABW-312 永無止境的陰道射精性愛。 15 連續陰道射精七島麻衣 - 七嶋舞', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/b388af81cc7e/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('320', '38', '0', '0', 'BONY-034 我會被我媽弄死的！一家人不停地擠，很快就垮了！望月綾香 - 望月彩花', '', 'BONY034wohuibeiwomanongsideyijiarenbutingdijihenkuaijiukualiaowangyuelingxiangwangyuecaihua', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/72324_cover_2025-02-22_122941.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/72324_cover_2025-02-22_122941.jpg', '', '', '', '', 'BONY-034 我會被我媽弄死的！一家人不停地擠，很快就垮了！望月綾香 - 望月彩花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '411', '625', '327', '576', '', '987', '871', '8.0', '6632', '829', '1740423657', '1740340835', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BONY-034 我會被我媽弄死的！一家人不停地擠，很快就垮了！望月綾香 - 望月彩花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/73742109a909/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('319', '38', '0', '0', 'TYSF-033 精準品酒師 Noka Yukari - 有加里ののか', '', 'TYSF033jingzhunpinjiushiNokaYukariyoujiali', '1', 'T', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/52102_cover_2025-02-22_122941.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/52102_cover_2025-02-22_122941.jpg', '', '', '', '', 'TYSF-033 精準品酒師 Noka Yukari - 有加里ののか', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '848', '356', '369', '342', '', '900', '577', '10.0', '6990', '699', '1740423657', '1740341197', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'TYSF-033 精準品酒師 Noka Yukari - 有加里ののか', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/1a9f8604cfd8/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('317', '38', '0', '0', 'GENU-002 低聲說髒話 W 蕩婦戲弄 M 男人 - 鈴木真夕', '', 'GENU002dishengshuizanghuaWdangfuxinongMnanrenlingmuzhenxi', '1', 'G', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/78555_cover_2025-02-22_124613.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/78555_cover_2025-02-22_124613.jpg', '', '', '', '', 'GENU-002 低聲說髒話 W 蕩婦戲弄 M 男人 - 鈴木真夕', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '629', '25', '643', '350', '', '634', '10', '3.0', '2841', '947', '1740423654', '1740342275', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'GENU-002 低聲說髒話 W 蕩婦戲弄 M 男人 - 鈴木真夕', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/41f8bfc0e00e/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('318', '38', '0', '0', 'IPX-990 與丈夫的同事穿著長裙偷偷反轉NTR，驚心動魄的連續蝕刻結束！木島愛里 - 希島愛里', '', 'IPX990yuzhangfudetongshichuanzhuchangquntoutoufanzhuanNTRjingxindongpodelianxushikejieshumudaoailixidaoaili', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/64702_cover_2025-02-22_124613.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/64702_cover_2025-02-22_124613.jpg', '', '', '', '', 'IPX-990 與丈夫的同事穿著長裙偷偷反轉NTR，驚心動魄的連續蝕刻結束！木島愛里 - 希島愛里', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '464', '876', '796', '409', '', '42', '293', '6.0', '2784', '464', '1740423657', '1740341735', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IPX-990 與丈夫的同事穿著長裙偷偷反轉NTR，驚心動魄的連續蝕刻結束！木島愛里 - 希島愛里', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9828480f9c35/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('316', '38', '0', '0', 'JUQ-170 在一次去溫泉慶祝我退休的旅行中，我的老闆繼續在我體內射精。由莉亞吉根 - 吉根柚莉愛', '', 'JUQ170zaiyiciquwenquanqingzhuwotuixiudelvxingzhongwodelaobanjixuzaiwotineishejingyouliyajigenjigenyouliai', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/88281_cover_2025-02-22_125844.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/88281_cover_2025-02-22_125844.jpg', '', '', '', '', 'JUQ-170 在一次去溫泉慶祝我退休的旅行中，我的老闆繼續在我體內射精。由莉亞吉根 - 吉根柚莉愛', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '654', '140', '614', '986', '', '439', '323', '3.0', '840', '280', '1740423654', '1740342815', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUQ-170 在一次去溫泉慶祝我退休的旅行中，我的老闆繼續在我體內射精。由莉亞吉根 - 吉根柚莉愛', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/708172f15297/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('315', '38', '0', '0', 'HUNTB-452 “只是一個吻。僅此而已。”舌頭纏繞的熱烈吻一直燃燒到燃燒的兩個人無法忍受。', '', 'HUNTB452zhishiyigewenjincieryishetouchanraodereliewenyizhiranshaodaoranshaodelianggerenwufarenshou', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/79364_cover_2025-02-22_124613.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/79364_cover_2025-02-22_124613.jpg', '', '', '', '', 'HUNTB-452 “只是一個吻。僅此而已。”舌頭纏繞的熱烈吻一直燃燒到燃燒的兩個人無法忍受。', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '907', '156', '402', '849', '', '187', '716', '7.0', '5579', '797', '1740423654', '1740343415', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HUNTB-452 “只是一個吻。僅此而已。”舌頭纏繞的熱烈吻一直燃燒到燃燒的兩個人無法忍受。', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a021098e5c04/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('314', '38', '0', '0', 'DASS-100 被派遣的按摩師摸我的秘密部位太多，我無法忍受快感，我被打倒了。望月綾香 - 望月彩花', '', 'DASS100beipaiqiandeanmoshimowodemimibuweitaiduowowufarenshoukuaiganwobeidadaoliaowangyuelingxiangwangyuecaihua', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/77555_cover_2025-02-22_125844.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/77555_cover_2025-02-22_125844.jpg', '', '', '', '', 'DASS-100 被派遣的按摩師摸我的秘密部位太多，我無法忍受快感，我被打倒了。望月綾香 - 望月彩花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '229', '978', '344', '501', '', '332', '526', '4.0', '1620', '405', '1740423654', '1740343895', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DASS-100 被派遣的按摩師摸我的秘密部位太多，我無法忍受快感，我被打倒了。望月綾香 - 望月彩花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/6b17021f99cc/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('313', '38', '0', '0', 'NGOD-186 全日本 Netorare 大獎得獎作品 舌吻吻 NTR 正經人妻向考試生告白勉強讓吻', '', 'NGOD186quanribenNetoraredajiangdejiangzuopinshewenwenNTRzhengjingrenqixiangkaoshishenggaobaimianqiangrangwen', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/30413_cover_2025-02-22_125844.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/30413_cover_2025-02-22_125844.jpg', '', '', '', '', 'NGOD-186 全日本 Netorare 大獎得獎作品 舌吻吻 NTR 正經人妻向考試生告白勉強讓吻', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '282', '72', '860', '810', '', '963', '732', '2.0', '1682', '841', '1740423654', '1740344435', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NGOD-186 全日本 Netorare 大獎得獎作品 舌吻吻 NTR 正經人妻向考試生告白勉強讓吻', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9acdb4c7664a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('312', '38', '0', '0', 'IPX-969 不要浪費時間立即操情婦沼澤-AIJINNUMA- Tsubasa Amami - 天海翼', '', 'IPX969buyaolangfeishijianlijicaoqingfuzhaozeAIJINNUMATsubasaAmamitianhaiyi', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/88952_cover_2025-02-22_132016.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/88952_cover_2025-02-22_132016.jpg', '', '', '', '', 'IPX-969 不要浪費時間立即操情婦沼澤-AIJINNUMA- Tsubasa Amami - 天海翼', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '468', '30', '130', '848', '', '559', '720', '4.0', '2784', '696', '1740423654', '1740344795', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IPX-969 不要浪費時間立即操情婦沼澤-AIJINNUMA- Tsubasa Amami - 天海翼', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/f47a0a017979/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('311', '38', '0', '0', 'SSIS-651 強行陪著生理上討厭死了的上司，強行陪著出差……滿身羞恥和體液被操了一整夜的人妻奧田咲希', '', 'SSIS651qiangxingpeizhushenglishangtaoyansiliaodeshangsiqiangxingpeizhuchuchamanshenxiuchihetiyebeicaoliaoyizhengyederenqiaotianxiaoxi', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/51277_cover_2025-02-22_132346.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/51277_cover_2025-02-22_132346.jpg', '', '', '', '', 'SSIS-651 強行陪著生理上討厭死了的上司，強行陪著出差……滿身羞恥和體液被操了一整夜的人妻奧田咲希', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '942', '775', '559', '474', '', '54', '264', '2.0', '968', '484', '1740423654', '1740345335', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-651 強行陪著生理上討厭死了的上司，強行陪著出差……滿身羞恥和體液被操了一整夜的人妻奧田咲希', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/26d839e79b10/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('310', '38', '0', '0', 'JUQ-176 當我被甜蜜的耳語席捲時，我淹沒在與已婚婦女的嵌套性愛中，直到我大學畢業。白石麻里奈', '', 'JUQ176dangwobeitianmideeryuxijuanshiwoyanmeizaiyuyihunfunvdeqiantaoxingaizhongzhidaowodaxuebiyebaishimalinai', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/50468_cover_2025-02-22_132346.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/50468_cover_2025-02-22_132346.jpg', '', '', '', '', 'JUQ-176 當我被甜蜜的耳語席捲時，我淹沒在與已婚婦女的嵌套性愛中，直到我大學畢業。白石麻里奈', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '945', '105', '594', '733', '', '427', '284', '10.0', '5280', '528', '1740423654', '1740345875', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUQ-176 當我被甜蜜的耳語席捲時，我淹沒在與已婚婦女的嵌套性愛中，直到我大學畢業。白石麻里奈', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/827842fb413d/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('309', '38', '0', '0', 'SSIS-593 交叉體液，深度性愛完全未切割特別南前田 - 前田美波', '', 'SSIS593jiaochatiyeshenduxingaiwanquanweiqiegetebienanqiantianqiantianmeibo', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/27339_cover_2025-02-22_132016.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/27339_cover_2025-02-22_132016.jpg', '', '', '', '', 'SSIS-593 交叉體液，深度性愛完全未切割特別南前田 - 前田美波', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '85', '426', '942', '152', '', '829', '388', '4.0', '2420', '605', '1740423654', '1740346415', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-593 交叉體液，深度性愛完全未切割特別南前田 - 前田美波', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/d15289c101ff/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('308', '38', '0', '0', 'JUQ-190 我繼續被我兒子的朋友無法控制的不忠交配變成魷魚...... Ryo Ayumi - 愛弓りょう', '', 'JUQ190wojixubeiwoerzidepengyouwufakongzhidebuzhongjiaopeibianchengyouyuRyoAyumiaigong', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/86675_cover_2025-02-22_132346.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/86675_cover_2025-02-22_132346.jpg', '', '', '', '', 'JUQ-190 我繼續被我兒子的朋友無法控制的不忠交配變成魷魚...... Ryo Ayumi - 愛弓りょう', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '662', '843', '750', '372', '', '698', '973', '6.0', '4176', '696', '1740423654', '1740346955', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUQ-190 我繼續被我兒子的朋友無法控制的不忠交配變成魷魚...... Ryo Ayumi - 愛弓りょう', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/d636013fa5c3/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('307', '38', '0', '0', 'DASS-101 雖然很蠢，但情色偏差值是天才級的。熱愛性愛的黑gal Himari-chan。木下日成利 - 木下日葵', '', 'DASS101suiranhenchundanqingsepianchazhishitiancaijidereaixingaideheigalHimarichanmuxiarichenglimuxiarikui', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/95213_cover_2025-02-22_132016.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/95213_cover_2025-02-22_132016.jpg', '', '', '', '', 'DASS-101 雖然很蠢，但情色偏差值是天才級的。熱愛性愛的黑gal Himari-chan。木下日成利 - 木下日葵', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '196', '702', '540', '793', '', '717', '299', '8.0', '1832', '229', '1740423654', '1740347495', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DASS-101 雖然很蠢，但情色偏差值是天才級的。熱愛性愛的黑gal Himari-chan。木下日成利 - 木下日葵', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/efa882a63a45/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('306', '38', '0', '0', 'SSIS-637 「誒，我錯過了末班電車！要不要讓你住我家？」 接受美女同事的邀請時，', '', 'SSIS637xiwocuoguoliaomobandiancheyaobuyaorangnizhuwojiajieshoumeinvtongshideyaoqingshi', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/92282_cover_2025-02-22_134748.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/92282_cover_2025-02-22_134748.jpg', '', '', '', '', 'SSIS-637 「誒，我錯過了末班電車！要不要讓你住我家？」 接受美女同事的邀請時，', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '149', '697', '721', '326', '', '328', '263', '3.0', '2028', '676', '1740423654', '1740348035', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-637 「誒，我錯過了末班電車！要不要讓你住我家？」 接受美女同事的邀請時，', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/05e5ecaadf53/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('305', '38', '0', '0', 'JUQ-192 裸體模特 NTR 攝影師和令人震驚的妻子羞恥溺水的作弊視頻 Kana Mito - 水戶香奈', '', 'JUQ192luotimoteNTRsheyingshihelingrenzhenjingdeqizixiuchinishuidezuobishipinKanaMitoshuihuxiangnai', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/82161_cover_2025-02-22_134748.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/82161_cover_2025-02-22_134748.jpg', '', '', '', '', 'JUQ-192 裸體模特 NTR 攝影師和令人震驚的妻子羞恥溺水的作弊視頻 Kana Mito - 水戶香奈', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '183', '907', '162', '768', '', '147', '104', '9.0', '6156', '684', '1740423654', '1740348395', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUQ-192 裸體模特 NTR 攝影師和令人震驚的妻子羞恥溺水的作弊視頻 Kana Mito - 水戶香奈', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/c93afc345bef/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('304', '38', '0', '0', 'IPX-983 代肉小便器 10 天懷孕坐月子生活與一個無與倫比的 Yakuza Oyaji 即使你射精或射精 Tsumugi Akari', '', 'IPX983dairouxiaobianqi10tianhuaiyunzuoyuezishenghuoyuyigewuyulunbideYakuzaOyajijishinishejinghuoshejingTsumugiAkari', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/71062_cover_2025-02-22_134748.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/71062_cover_2025-02-22_134748.jpg', '', '', '', '', 'IPX-983 代肉小便器 10 天懷孕坐月子生活與一個無與倫比的 Yakuza Oyaji 即使你射精或射精 Tsumugi Akari', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '784', '51', '382', '612', '', '414', '864', '6.0', '2118', '353', '1740423654', '1740348935', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IPX-983 代肉小便器 10 天懷孕坐月子生活與一個無與倫比的 Yakuza Oyaji 即使你射精或射精 Tsumugi Akari', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/37284b9ec031/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('303', '38', '0', '0', 'IPX-989 “你會愛上我的……” ≪APP匹配≫ 見面後馬上就到酒店。西宮夢', '', 'IPX989nihuiaishangwodeAPPpipeijianmianhoumashangjiudaojiudianxigongmeng', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/68757_cover_2025-02-22_135348.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/68757_cover_2025-02-22_135348.jpg', '', '', '', '', 'IPX-989 “你會愛上我的……” ≪APP匹配≫ 見面後馬上就到酒店。西宮夢', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '477', '404', '441', '111', '', '429', '324', '10.0', '590', '59', '1740423654', '1740349475', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IPX-989 “你會愛上我的……” ≪APP匹配≫ 見面後馬上就到酒店。西宮夢', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/03161110e74f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('302', '38', '0', '0', 'SSIS-647 無法抗拒快感，無法抗拒快感，無法停止抽筋，也無法停止性愛精油按摩 Mirei Shinonome - 東雲', '', 'SSIS647wufakangjukuaiganwufakangjukuaiganwufatingzhichoujinyewufatingzhixingaijingyouanmoMireiShinonomedongyun', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/96699_cover_2025-02-22_135348.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/96699_cover_2025-02-22_135348.jpg', '', '', '', '', 'SSIS-647 無法抗拒快感，無法抗拒快感，無法停止抽筋，也無法停止性愛精油按摩 Mirei Shinonome - 東雲', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '161', '215', '519', '583', '', '978', '155', '6.0', '1710', '285', '1740423654', '1740350015', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-647 無法抗拒快感，無法抗拒快感，無法停止抽筋，也無法停止性愛精油按摩 Mirei Shinonome - 東雲', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/731e71e4180f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('301', '38', '0', '0', 'IPX-978 被好色的巨乳姐姐在郊外的情趣旅館一直淫蕩到凌晨的淫蕩紀錄片！ 24 小時亞拉約會！梓光 - 梓光莉', '', 'IPX978beihaosedejurujiejiezaijiaowaideqingqulvguanyizhiyindangdaolingchendeyindangjilupian24xiaoshiyalayuehuiziguangziguangli', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/82988_cover_2025-02-22_135348.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/82988_cover_2025-02-22_135348.jpg', '', '', '', '', 'IPX-978 被好色的巨乳姐姐在郊外的情趣旅館一直淫蕩到凌晨的淫蕩紀錄片！ 24 小時亞拉約會！梓光 - 梓光莉', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '313', '876', '815', '693', '', '565', '846', '5.0', '4080', '816', '1740423654', '1740350559', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IPX-978 被好色的巨乳姐姐在郊外的情趣旅館一直淫蕩到凌晨的淫蕩紀錄片！ 24 小時亞拉約會！梓光 - 梓光莉', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/86a8ce416669/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('300', '38', '0', '0', 'IPX-980 在同學會上與曾經深愛過的男人重逢，與曾經深愛過的男人發生性關係，反复性中出…', '', 'IPX980zaitongxuehuishangyuzengjingshenaiguodenanrenzhongfengyuzengjingshenaiguodenanrenfashengxingguanxifanfuxingzhongchu', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/23877_cover_2025-02-22_140850.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/23877_cover_2025-02-22_140850.jpg', '', '', '', '', 'IPX-980 在同學會上與曾經深愛過的男人重逢，與曾經深愛過的男人發生性關係，反复性中出…', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '813', '30', '162', '978', '', '634', '991', '4.0', '3724', '931', '1740423654', '1740351097', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IPX-980 在同學會上與曾經深愛過的男人重逢，與曾經深愛過的男人發生性關係，反复性中出…', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/893ec93918e8/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('299', '38', '0', '0', 'IPX-986 不自覺地向不穿胸罩的乳頭提出上訴的巨乳姐姐 自然淫蕩的誘惑性愛摩擦 Lcup 詛咒我的神聖乳房', '', 'IPX986buzijuedixiangbuchuanxiongzhaoderutoutichushangsudejurujiejieziranyindangdeyouhuoxingaimocaLcupzuzhouwodeshenshengrufang', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/63180_cover_2025-02-22_140850.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/63180_cover_2025-02-22_140850.jpg', '', '', '', '', 'IPX-986 不自覺地向不穿胸罩的乳頭提出上訴的巨乳姐姐 自然淫蕩的誘惑性愛摩擦 Lcup 詛咒我的神聖乳房', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '480', '825', '138', '877', '', '449', '895', '10.0', '4490', '449', '1740423654', '1740351635', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IPX-986 不自覺地向不穿胸罩的乳頭提出上訴的巨乳姐姐 自然淫蕩的誘惑性愛摩擦 Lcup 詛咒我的神聖乳房', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/60487af1b4c9/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('298', '38', '0', '0', 'SSIS-570 Yua Mikami 完整的私人性愛都被拿走了！壓倒性地支持頂級女演員和原始奇聞趣事獨自操到早上', '', 'SSIS570YuaMikamiwanzhengdesirenxingaidubeinazouliaoyadaoxingdizhichidingjinvyanyuanheyuanshiqiwenqushiduzicaodaozaoshang', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/48805_cover_2025-02-22_142151.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/48805_cover_2025-02-22_142151.jpg', '', '', '', '', 'SSIS-570 Yua Mikami 完整的私人性愛都被拿走了！壓倒性地支持頂級女演員和原始奇聞趣事獨自操到早上', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '518', '533', '599', '769', '', '972', '790', '5.0', '2860', '572', '1740423654', '1740351995', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-570 Yua Mikami 完整的私人性愛都被拿走了！壓倒性地支持頂級女演員和原始奇聞趣事獨自操到早上', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/14fc4326f62c/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('296', '38', '0', '0', 'ALDN-110 母親的強姦中出 第一次被兒子射精的伊織涼子母親', '', 'ALDN110muqindeqiangjianzhongchudiyicibeierzishejingdeyizhiliangzimuqin', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/29602_cover_2025-02-22_143852.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/29602_cover_2025-02-22_143852.jpg', '', '', '', '', 'ALDN-110 母親的強姦中出 第一次被兒子射精的伊織涼子母親', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '119', '44', '588', '928', '', '551', '411', '9.0', '2970', '330', '1740423650', '1740353075', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-110 母親的強姦中出 第一次被兒子射精的伊織涼子母親', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/442949c1472c/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('297', '38', '0', '0', 'SSIS-580 太有活力了！初體驗3 製作現役高規格女大學生性能力驚人！宮城理惠 - 宮城りえ', '', 'SSIS580taiyouhuoliliaochutiyan3zhizuoxianyigaoguigenvdaxueshengxingnenglijingrengongchenglihuigongcheng', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/35637_cover_2025-02-22_140850.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/35637_cover_2025-02-22_140850.jpg', '', '', '', '', 'SSIS-580 太有活力了！初體驗3 製作現役高規格女大學生性能力驚人！宮城理惠 - 宮城りえ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '254', '14', '213', '80', '', '908', '771', '9.0', '6615', '735', '1740423650', '1740352535', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-580 太有活力了！初體驗3 製作現役高規格女大學生性能力驚人！宮城理惠 - 宮城りえ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/2390192f43c0/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('295', '38', '0', '0', 'SSIS-653 Rookie NO.1 STYLE 伊藤聖佳 - 伊藤聖夏', '', 'SSIS653RookieNO1STYLEyitengshengjiayitengshengxia', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/79027_cover_2025-02-22_142151.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/79027_cover_2025-02-22_142151.jpg', '', '', '', '', 'SSIS-653 Rookie NO.1 STYLE 伊藤聖佳 - 伊藤聖夏', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '29', '880', '585', '249', '', '505', '728', '5.0', '4835', '967', '1740423650', '1740353615', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-653 Rookie NO.1 STYLE 伊藤聖佳 - 伊藤聖夏', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/5f06eb0691f2/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('294', '38', '0', '0', 'SSIS-638 名人 Alice Shinomiya Ban On 全裸敏感 100 Iki 3 Productions - 四宮ありす', '', 'SSIS638mingrenAliceShinomiyaBanOnquanluomingan100Iki3Productionssigong', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/50318_cover_2025-02-22_142151.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/50318_cover_2025-02-22_142151.jpg', '', '', '', '', 'SSIS-638 名人 Alice Shinomiya Ban On 全裸敏感 100 Iki 3 Productions - 四宮ありす', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '878', '324', '622', '683', '', '143', '345', '10.0', '8980', '898', '1740423650', '1740354155', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-638 名人 Alice Shinomiya Ban On 全裸敏感 100 Iki 3 Productions - 四宮ありす', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/acc96f570987/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('293', '38', '0', '0', 'SABA-807 出賣身體求職的求職女大學生過於極端的權力騷擾面試視頻... 原汁原味的陰道射精自我PR Vol.003', '', 'SABA807chumaishentiqiuzhideqiuzhinvdaxueshengguoyujiduandequanlisaoraomianshishipinyuanzhiyuanweideyindaoshejingziwoPRVol003', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/75727_cover_2025-02-22_143852.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/75727_cover_2025-02-22_143852.jpg', '', '', '', '', 'SABA-807 出賣身體求職的求職女大學生過於極端的權力騷擾面試視頻... 原汁原味的陰道射精自我PR Vol.003', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '757', '800', '372', '543', '', '13', '294', '3.0', '1110', '370', '1740423650', '1740354695', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SABA-807 出賣身體求職的求職女大學生過於極端的權力騷擾面試視頻... 原汁原味的陰道射精自我PR Vol.003', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/f1af57be0b94/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('292', '38', '0', '0', 'ALDN-114 Yuri Tadokoro 讓她的公公在沒有告訴她丈夫的情況下懷孕 - 田所百合', '', 'ALDN114YuriTadokororangtadegonggongzaimeiyougaosutazhangfudeqingkuangxiahuaiyuntiansuobaihe', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/31714_cover_2025-02-22_143852.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/31714_cover_2025-02-22_143852.jpg', '', '', '', '', 'ALDN-114 Yuri Tadokoro 讓她的公公在沒有告訴她丈夫的情況下懷孕 - 田所百合', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '114', '370', '573', '102', '', '53', '407', '10.0', '5290', '529', '1740423650', '1740355235', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-114 Yuri Tadokoro 讓她的公公在沒有告訴她丈夫的情況下懷孕 - 田所百合', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/2710e321dd3d/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('291', '38', '0', '0', 'ALDN-111 裸體繼母堇三原 - 美原堇', '', 'ALDN111luotijimujinsanyuanmeiyuanjin', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/45133_cover_2025-02-22_145454.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/45133_cover_2025-02-22_145454.jpg', '', '', '', '', 'ALDN-111 裸體繼母堇三原 - 美原堇', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '935', '698', '597', '595', '', '11', '543', '7.0', '3255', '465', '1740423650', '1740355596', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-111 裸體繼母堇三原 - 美原堇', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/11d6d25a653a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('290', '38', '0', '0', 'ALDN-109 畢竟再婚對象之前的大老婆也不錯啊……中山穗香', '', 'ALDN109bijingzaihunduixiangzhiqiandedalaopoyebucuoazhongshansuixiang', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/74701_cover_2025-02-22_145454.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/74701_cover_2025-02-22_145454.jpg', '', '', '', '', 'ALDN-109 畢竟再婚對象之前的大老婆也不錯啊……中山穗香', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '569', '964', '945', '676', '', '165', '882', '1.0', '855', '855', '1740423650', '1740356135', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-109 畢竟再婚對象之前的大老婆也不錯啊……中山穗香', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/bb1058c1142c/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('288', '38', '0', '0', 'MDTM-797 我試著養了一個出賣身體的製服少女。 01 - 朝日りん', '', 'MDTM797woshizhuyangliaoyigechumaishentidezhifushaonv01chaori', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/81961_cover_2025-02-22_150425.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/81961_cover_2025-02-22_150425.jpg', '', '', '', '', 'MDTM-797 我試著養了一個出賣身體的製服少女。 01 - 朝日りん', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '931', '859', '669', '194', '', '398', '136', '6.0', '1962', '327', '1740423650', '1740357215', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MDTM-797 我試著養了一個出賣身體的製服少女。 01 - 朝日りん', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/7eba89ecee4d/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('289', '38', '0', '0', 'ALDN-112 我想擁抱我的前妻成宮伊呂波 - 成宮彩葉', '', 'ALDN112woxiangyongbaowodeqianqichenggongyilvbochenggongcaiye', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/56487_cover_2025-02-22_145454.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/56487_cover_2025-02-22_145454.jpg', '', '', '', '', 'ALDN-112 我想擁抱我的前妻成宮伊呂波 - 成宮彩葉', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '608', '146', '233', '916', '', '303', '19', '2.0', '1024', '512', '1740423650', '1740356675', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-112 我想擁抱我的前妻成宮伊呂波 - 成宮彩葉', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/18de4980429b/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('286', '38', '0', '0', 'ALDN-113 我敬佩的前輩是……鈴木真由 - 鈴木真夕', '', 'ALDN113wojingpeideqianbeishilingmuzhenyoulingmuzhenxi', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/47524_cover_2025-02-22_150425.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/47524_cover_2025-02-22_150425.jpg', '', '', '', '', 'ALDN-113 我敬佩的前輩是……鈴木真由 - 鈴木真夕', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '143', '156', '499', '283', '', '673', '874', '9.0', '270', '30', '1740423650', '1740358295', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-113 我敬佩的前輩是……鈴木真由 - 鈴木真夕', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/fa9364661965/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('287', '38', '0', '0', 'MDTM-798 Ikuiku早洩敏感正妹與排卵日生子製作物語雙特輯！ ACT.002 小月惠奈 &amp;amp; 愛野日向 - 沙月惠奈', '', 'MDTM798IkuikuzaoxieminganzhengmeiyupailuanrishengzizhizuowuyushuangtejiACT002xiaoyuehuinaiampaiyerixiangshayuehuinai', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/10329_cover_2025-02-22_150425.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/10329_cover_2025-02-22_150425.jpg', '', '', '', '', 'MDTM-798 Ikuiku早洩敏感正妹與排卵日生子製作物語雙特輯！ ACT.002 小月惠奈 &amp;amp; 愛野日向 - 沙月惠奈', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '627', '991', '351', '225', '', '39', '345', '1.0', '267', '267', '1740423650', '1740357755', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MDTM-798 Ikuiku早洩敏感正妹與排卵日生子製作物語雙特輯！ ACT.002 小月惠奈 & 愛野日向 - 沙月惠奈', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/1fb14c2736d2/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('285', '38', '0', '0', 'ALDN-108 婆婆，比我老婆好多了……伊藤莎蘭 - 伊東沙蘭', '', 'ALDN108popobiwolaopohaoduoliaoyitengshalanyidongshalan', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/77618_cover_2025-02-22_151956.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/77618_cover_2025-02-22_151956.jpg', '', '', '', '', 'ALDN-108 婆婆，比我老婆好多了……伊藤莎蘭 - 伊東沙蘭', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '454', '703', '740', '282', '', '188', '409', '7.0', '5607', '801', '1740423650', '1740358835', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-108 婆婆，比我老婆好多了……伊藤莎蘭 - 伊東沙蘭', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/15cb8df63c77/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('284', '38', '0', '0', 'NSFS-151 岳父和兒媳夏日秘密4 中條理乃 - 中條りの', '', 'NSFS151yuefuheerxixiarimimi4zhongtiaolinaizhongtiao', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/82739_cover_2025-02-22_151956.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/82739_cover_2025-02-22_151956.jpg', '', '', '', '', 'NSFS-151 岳父和兒媳夏日秘密4 中條理乃 - 中條りの', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '114', '949', '658', '895', '', '851', '293', '7.0', '3850', '550', '1740423650', '1740359195', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NSFS-151 岳父和兒媳夏日秘密4 中條理乃 - 中條りの', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/8b9d440d26d8/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('283', '38', '0', '0', 'NSFS-152 住在破舊公寓裡的可憐妻子被害羞的男人射精……佐藤野野 - 加藤桃香', '', 'NSFS152zhuzaipojiugongyulidekelianqizibeihaixiudenanrenshejingzuotengyeyejiatengtaoxiang', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/55076_cover_2025-02-22_151956.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/55076_cover_2025-02-22_151956.jpg', '', '', '', '', 'NSFS-152 住在破舊公寓裡的可憐妻子被害羞的男人射精……佐藤野野 - 加藤桃香', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '533', '329', '474', '436', '', '107', '437', '3.0', '1998', '666', '1740423650', '1740359737', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NSFS-152 住在破舊公寓裡的可憐妻子被害羞的男人射精……佐藤野野 - 加藤桃香', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/09efbd1b6e06/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('282', '38', '0', '0', 'DVAJ-603 治療師超凡手技持續勃起持續不耐煩 多巴多巴大量射精排毒尾崎繪梨香最後一分鐘', '', 'DVAJ603zhiliaoshichaofanshoujichixuboqichixubunaifanduobaduobadaliangshejingpaiduweiqihuilixiangzuihouyifenzhong', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/38289_cover_2025-02-22_153027.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/38289_cover_2025-02-22_153027.jpg', '', '', '', '', 'DVAJ-603 治療師超凡手技持續勃起持續不耐煩 多巴多巴大量射精排毒尾崎繪梨香最後一分鐘', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '353', '930', '445', '836', '', '292', '411', '5.0', '4655', '931', '1740423650', '1740360275', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DVAJ-603 治療師超凡手技持續勃起持續不耐煩 多巴多巴大量射精排毒尾崎繪梨香最後一分鐘', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9cc3653792a4/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('281', '38', '0', '0', 'URKK-073 被隔壁變態房東揉奶天天被強姦寶田毛奈美 - 寶田望愛實', '', 'URKK073beigebibiantaifangdongrounaitiantianbeiqiangjianbaotianmaonaimeibaotianwangaishi', '1', 'U', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/63195_cover_2025-02-22_153027.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/63195_cover_2025-02-22_153027.jpg', '', '', '', '', 'URKK-073 被隔壁變態房東揉奶天天被強姦寶田毛奈美 - 寶田望愛實', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '507', '570', '613', '130', '', '242', '866', '7.0', '3514', '502', '1740423650', '1740360817', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'URKK-073 被隔壁變態房東揉奶天天被強姦寶田毛奈美 - 寶田望愛實', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/e8f341bcce8e/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('280', '38', '0', '0', 'MKMP-501 Ria Shinkai First Orgasm 3 製作 - 神海リア', '', 'MKMP501RiaShinkaiFirstOrgasm3zhizuoshenhai', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/54404_cover_2025-02-22_153027.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/54404_cover_2025-02-22_153027.jpg', '', '', '', '', 'MKMP-501 Ria Shinkai First Orgasm 3 製作 - 神海リア', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '28', '910', '243', '990', '', '227', '990', '8.0', '7400', '925', '1740423650', '1740361355', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MKMP-501 Ria Shinkai First Orgasm 3 製作 - 神海リア', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/6fd5cb86c305/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('279', '38', '0', '0', 'DVAJ-604 就在射精前，我用低速揉搓刺激我的雞巴，然後用爆炸樁驅動活塞將其驅動到射精的最後一刻', '', 'DVAJ604jiuzaishejingqianwoyongdisuroucuocijiwodejibaranhouyongbaozhazhuangqudonghuosaijiangqiqudongdaoshejingdezuihouyike', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/61190_cover_2025-02-22_154258.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/61190_cover_2025-02-22_154258.jpg', '', '', '', '', 'DVAJ-604 就在射精前，我用低速揉搓刺激我的雞巴，然後用爆炸樁驅動活塞將其驅動到射精的最後一刻', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '535', '432', '82', '38', '', '541', '44', '2.0', '544', '272', '1740423650', '1740361895', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DVAJ-604 就在射精前，我用低速揉搓刺激我的雞巴，然後用爆炸樁驅動活塞將其驅動到射精的最後一刻', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/8d3c6967b0cc/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('277', '38', '0', '0', 'MKMP-502 非 Kobana 中出孕育新婚生活 - 小花のん', '', 'MKMP502feiKobanazhongchuyunyuxinhunshenghuoxiaohua', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/88279_cover_2025-02-22_154258.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/88279_cover_2025-02-22_154258.jpg', '', '', '', '', 'MKMP-502 非 Kobana 中出孕育新婚生活 - 小花のん', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '567', '82', '767', '903', '', '8', '699', '4.0', '3340', '835', '1740423647', '1740362795', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MKMP-502 非 Kobana 中出孕育新婚生活 - 小花のん', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/81097ca86395/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('278', '38', '0', '0', 'MKMP-503 一個太喜歡我的小輩，脫下衣服的時候連從衣服上面都不敢想像！', '', 'MKMP503yigetaixihuanwodexiaobeituoxiayifudeshihouliancongyifushangmiandubuganxiangxiang', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/41542_cover_2025-02-22_154258.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/41542_cover_2025-02-22_154258.jpg', '', '', '', '', 'MKMP-503 一個太喜歡我的小輩，脫下衣服的時候連從衣服上面都不敢想像！', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '972', '499', '132', '575', '', '992', '380', '5.0', '1725', '345', '1740423650', '1740362435', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MKMP-503 一個太喜歡我的小輩，脫下衣服的時候連從衣服上面都不敢想像！', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/98c71595d8ef/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('276', '38', '0', '0', 'IENF-247 可以建立男女友情嗎！？僅限女學生！ - 由良かな', '', 'IENF247keyijianlinannvyouqingmajinxiannvxueshengyouliang', '1', 'I', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/48865_cover_2025-02-22_155830.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/48865_cover_2025-02-22_155830.jpg', '', '', '', '', 'IENF-247 可以建立男女友情嗎！？僅限女學生！ - 由良かな', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '188', '172', '757', '901', '', '926', '212', '5.0', '2685', '537', '1740423647', '1740363335', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'IENF-247 可以建立男女友情嗎！？僅限女學生！ - 由良かな', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a807879dc97b/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('275', '38', '0', '0', 'HBAD-646 再婚後同居的野女兒，為了媽媽被訓練成性加工女 - 有加里ののか', '', 'HBAD646zaihunhoutongjudeyenverweiliaomamabeixunlianchengxingjiagongnvyoujiali', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/34800_cover_2025-02-22_155830.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/34800_cover_2025-02-22_155830.jpg', '', '', '', '', 'HBAD-646 再婚後同居的野女兒，為了媽媽被訓練成性加工女 - 有加里ののか', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '649', '226', '749', '274', '', '64', '475', '10.0', '3890', '389', '1740423647', '1740363875', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HBAD-646 再婚後同居的野女兒，為了媽媽被訓練成性加工女 - 有加里ののか', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/21cd46834948/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('274', '38', '0', '0', 'GS-458 粗糙的下巴被刺激的按摩院乞求！！在傳聞中的男士按摩院完全勃起！因為實在是無法抗拒的滴答作響', '', 'GS458cucaodexiababeicijideanmoyuanqiqiuzaichuanwenzhongdenanshianmoyuanwanquanboqiyinweishizaishiwufakangjudedidazuoxiang', '1', 'G', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/78417_cover_2025-02-22_155830.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/78417_cover_2025-02-22_155830.jpg', '', '', '', '', 'GS-458 粗糙的下巴被刺激的按摩院乞求！！在傳聞中的男士按摩院完全勃起！因為實在是無法抗拒的滴答作響', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '359', '229', '181', '844', '', '493', '312', '1.0', '666', '666', '1740423647', '1740364355', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'GS-458 粗糙的下巴被刺激的按摩院乞求！！在傳聞中的男士按摩院完全勃起！因為實在是無法抗拒的滴答作響', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/fe3261e360e0/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('273', '38', '0', '0', 'DVDMS-907 咬丁字褲勾引我的大屁股鄰家老婆Panchira 2 粗屁股完全勃起精子被多次擠壓', '', 'DVDMS907yaodingzikugouyinwodedapigulinjialaopoPanchira2cupiguwanquanboqijingzibeiduocijiya', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/18092_cover_2025-02-22_161201.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/18092_cover_2025-02-22_161201.jpg', '', '', '', '', 'DVDMS-907 咬丁字褲勾引我的大屁股鄰家老婆Panchira 2 粗屁股完全勃起精子被多次擠壓', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '141', '489', '572', '616', '', '155', '965', '4.0', '116', '29', '1740423647', '1740364955', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DVDMS-907 咬丁字褲勾引我的大屁股鄰家老婆Panchira 2 粗屁股完全勃起精子被多次擠壓', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/88706636a48f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('272', '38', '0', '0', 'FSDSS-531 戶田誠，退休。我最不想做的事 - 戶田真琴', '', 'FSDSS531hutianchengtuixiuwozuibuxiangzuodeshihutianzhenqin', '1', 'F', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/74253_cover_2025-02-22_161201.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/74253_cover_2025-02-22_161201.jpg', '', '', '', '', 'FSDSS-531 戶田誠，退休。我最不想做的事 - 戶田真琴', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '558', '176', '510', '601', '', '422', '927', '8.0', '5984', '748', '1740423647', '1740365495', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'FSDSS-531 戶田誠，退休。我最不想做的事 - 戶田真琴', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/76a2e6926503/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('271', '38', '0', '0', 'BOBB-363 白大衣Jcup天使從護士叫boin開始的秘密乳腺護理「Soka Minamihata」箱 - 南畑颯花', '', 'BOBB363baidayiJcuptianshiconghushijiaoboinkaishidemimiruxianhuliSokaMinamihataxiangnantiansahua', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/58754_cover_2025-02-22_161201.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/58754_cover_2025-02-22_161201.jpg', '', '', '', '', 'BOBB-363 白大衣Jcup天使從護士叫boin開始的秘密乳腺護理「Soka Minamihata」箱 - 南畑颯花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '198', '762', '462', '800', '', '67', '647', '4.0', '1412', '353', '1740423647', '1740366035', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BOBB-363 白大衣Jcup天使從護士叫boin開始的秘密乳腺護理「Soka Minamihata」箱 - 南畑颯花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/c758147a294a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('270', '38', '0', '0', 'PRED-449 趁著老闆出差，我和一個推不動的巨乳老婆偷情了3天。茱莉亞 - JULIA', '', 'PRED449chenzhulaobanchuchawoheyigetuibudongdejurulaopotouqingliao3tianzhuliyaJULIA', '1', 'P', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/56982_cover_2025-02-22_162503.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/56982_cover_2025-02-22_162503.jpg', '', '', '', '', 'PRED-449 趁著老闆出差，我和一個推不動的巨乳老婆偷情了3天。茱莉亞 - JULIA', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '503', '70', '884', '283', '', '797', '411', '7.0', '5915', '845', '1740423647', '1740366395', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'PRED-449 趁著老闆出差，我和一個推不動的巨乳老婆偷情了3天。茱莉亞 - JULIA', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/b95e09d4ac8e/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('269', '38', '0', '0', 'MIAA-755 我成年了，但我從來沒有過性生活，這不是很蹩腳嗎？勞拉與明日堂~玩拉拉工藤 - 工藤ララ', '', 'MIAA755wochengnianliaodanwoconglaimeiyouguoxingshenghuozhebushihenbiejiaomalaolayumingritangwanlalagongtenggongteng', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/33590_cover_2025-02-22_162503.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/33590_cover_2025-02-22_162503.jpg', '', '', '', '', 'MIAA-755 我成年了，但我從來沒有過性生活，這不是很蹩腳嗎？勞拉與明日堂~玩拉拉工藤 - 工藤ララ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '47', '924', '430', '550', '', '955', '821', '7.0', '3570', '510', '1740423647', '1740366935', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MIAA-755 我成年了，但我從來沒有過性生活，這不是很蹩腳嗎？勞拉與明日堂~玩拉拉工藤 - 工藤ララ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/73e6b5532347/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('268', '38', '0', '0', 'EBOD-955 選擇一個擁有天然神乳的好女人。終極美麗的巨乳戀物癖視頻 Ena Koume - 小梅惠奈', '', 'EBOD955xuanzeyigeyongyoutianranshenrudehaonvrenzhongjimeilidejurulianwupishipinEnaKoumexiaomeihuinai', '1', 'E', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/88967_cover_2025-02-22_162503.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/88967_cover_2025-02-22_162503.jpg', '', '', '', '', 'EBOD-955 選擇一個擁有天然神乳的好女人。終極美麗的巨乳戀物癖視頻 Ena Koume - 小梅惠奈', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '394', '682', '696', '154', '', '609', '406', '8.0', '4272', '534', '1740423647', '1740367475', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'EBOD-955 選擇一個擁有天然神乳的好女人。終極美麗的巨乳戀物癖視頻 Ena Koume - 小梅惠奈', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/c0382dc65636/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('267', '38', '0', '0', 'MIAA-727 妹妹是貨真價實的小惡魔護士假裝投入玩弄我卡住的雞巴高潮破滅…松本一花 - 松本一香', '', 'MIAA727meimeishihuozhenjiashidexiaoemohushijiazhuangtouruwannongwokazhudejibagaochaopomiesongbenyihuasongbenyixiang', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/34179_cover_2025-02-22_164734.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/34179_cover_2025-02-22_164734.jpg', '', '', '', '', 'MIAA-727 妹妹是貨真價實的小惡魔護士假裝投入玩弄我卡住的雞巴高潮破滅…松本一花 - 松本一香', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '329', '656', '706', '728', '', '77', '320', '10.0', '9830', '983', '1740423647', '1740368015', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MIAA-727 妹妹是貨真價實的小惡魔護士假裝投入玩弄我卡住的雞巴高潮破滅…松本一花 - 松本一香', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a2a1211cdbb1/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('266', '38', '0', '0', 'JUFE-440 修學旅行時被巨乳人妻女教師調教，風靡一時的狹山愛 - 佐山愛', '', 'JUFE440xiuxuelvxingshibeijururenqinvjiaoshidiaojiaofengmiyishidexiashanaizuoshanai', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/62863_cover_2025-02-22_164404.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/62863_cover_2025-02-22_164404.jpg', '', '', '', '', 'JUFE-440 修學旅行時被巨乳人妻女教師調教，風靡一時的狹山愛 - 佐山愛', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '705', '165', '883', '397', '', '42', '698', '9.0', '1503', '167', '1740423647', '1740368554', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUFE-440 修學旅行時被巨乳人妻女教師調教，風靡一時的狹山愛 - 佐山愛', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/dedad44984d4/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('265', '38', '0', '0', 'MVSD-534 我們公司素顏豐滿熟女員工竟是巨屌好色大媽酒會結束後帶回家，到早上是8拍！ Mocchiri 裝載餅性', '', 'MVSD534womengongsisuyanfengmanshunvyuangongjingshijudiaohaosedamajiuhuijieshuhoudaihuijiadaozaoshangshi8paiMocchirizhuangzaibingxing', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/47954_cover_2025-02-22_164404.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/47954_cover_2025-02-22_164404.jpg', '', '', '', '', 'MVSD-534 我們公司素顏豐滿熟女員工竟是巨屌好色大媽酒會結束後帶回家，到早上是8拍！ Mocchiri 裝載餅性', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '98', '729', '92', '988', '', '242', '313', '3.0', '2712', '904', '1740423647', '1740369035', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MVSD-534 我們公司素顏豐滿熟女員工竟是巨屌好色大媽酒會結束後帶回家，到早上是8拍！ Mocchiri 裝載餅性', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/1cd32bb8bb01/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('264', '38', '0', '0', 'MIAA-776 如果你知道了，你的家庭會崩潰！我妻子的姐姐的 Ijiwari 耳語髒話和倒計時訓練誘惑', '', 'MIAA776ruguonizhidaoliaonidejiatinghuibengkuiwoqizidejiejiedeIjiwarieryuzanghuahedaojishixunlianyouhuo', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/11333_cover_2025-02-22_164734.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/11333_cover_2025-02-22_164734.jpg', '', '', '', '', 'MIAA-776 如果你知道了，你的家庭會崩潰！我妻子的姐姐的 Ijiwari 耳語髒話和倒計時訓練誘惑', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '445', '966', '398', '449', '', '616', '575', '10.0', '8570', '857', '1740423647', '1740369575', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MIAA-776 如果你知道了，你的家庭會崩潰！我妻子的姐姐的 Ijiwari 耳語髒話和倒計時訓練誘惑', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/b225832fd060/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('263', '38', '0', '0', 'MIAA-780 和最近被撿到的男人在溫泉旅行中嘗試性交單身漢的最後記憶時…無雙智寶太引人注目', '', 'MIAA780hezuijinbeijiandaodenanrenzaiwenquanlvxingzhongchangshixingjiaodanshenhandezuihoujiyishiwushuangzhibaotaiyinrenzhumu', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/44305_cover_2025-02-22_164734.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/44305_cover_2025-02-22_164734.jpg', '', '', '', '', 'MIAA-780 和最近被撿到的男人在溫泉旅行中嘗試性交單身漢的最後記憶時…無雙智寶太引人注目', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '273', '299', '15', '252', '', '615', '182', '7.0', '343', '49', '1740423647', '1740369935', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MIAA-780 和最近被撿到的男人在溫泉旅行中嘗試性交單身漢的最後記憶時…無雙智寶太引人注目', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/b1d0b08678f0/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('262', '38', '0', '0', 'MUDR-212 實習女○學生性騷擾上司和合租房間出差口水滿臉舔中出深喉NTR日向由良 - 日嚮ゆら', '', 'MUDR212shixinvxueshengxingsaoraoshangsihehezufangjianchuchakoushuimanliantianzhongchushenhouNTRrixiangyouliangrixiang', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/30159_cover_2025-02-22_164404.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/30159_cover_2025-02-22_164404.jpg', '', '', '', '', 'MUDR-212 實習女○學生性騷擾上司和合租房間出差口水滿臉舔中出深喉NTR日向由良 - 日嚮ゆら', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '689', '165', '902', '668', '', '413', '811', '5.0', '3220', '644', '1740423647', '1740370535', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MUDR-212 實習女○學生性騷擾上司和合租房間出差口水滿臉舔中出深喉NTR日向由良 - 日嚮ゆら', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/8bc03689dd23/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('261', '38', '0', '0', 'MIMK-112 一個當地的朋友。 《深夜便利店店員A》累計銷量突破25000份！ 24 小時當你想做愛', '', 'MIMK112yigedangdidepengyoushenyebianlidiandianyuanAleijixiaoliangtupo25000fen24xiaoshidangnixiangzuoai', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/50951_cover_2025-02-22_171106.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/50951_cover_2025-02-22_171106.jpg', '', '', '', '', 'MIMK-112 一個當地的朋友。 《深夜便利店店員A》累計銷量突破25000份！ 24 小時當你想做愛', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '290', '538', '202', '724', '', '755', '200', '3.0', '2079', '693', '1740423647', '1740371075', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MIMK-112 一個當地的朋友。 《深夜便利店店員A》累計銷量突破25000份！ 24 小時當你想做愛', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/44f529fe8238/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('260', '38', '0', '0', 'PPPE-093 Spence 乳房發育診所 Kobana Non - 小花のん', '', 'PPPE093SpencerufangfayuzhensuoKobanaNonxiaohua', '1', 'P', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/43732_cover_2025-02-22_170736.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/43732_cover_2025-02-22_170736.jpg', '', '', '', '', 'PPPE-093 Spence 乳房發育診所 Kobana Non - 小花のん', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '109', '260', '573', '961', '', '859', '593', '9.0', '8937', '993', '1740423647', '1740371615', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'PPPE-093 Spence 乳房發育診所 Kobana Non - 小花のん', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/bf489df5ac18/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('259', '38', '0', '0', 'MIDV-259 被猜測的病人塗上春藥後無法停止性交和陰道射精的 Kimeseku 巨乳護士 Fumika Nakayama', '', 'MIDV259beicaicedebingrentushangchunyaohouwufatingzhixingjiaoheyindaoshejingdeKimesekujuruhushiFumikaNakayama', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/56461_cover_2025-02-22_171106.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/56461_cover_2025-02-22_171106.jpg', '', '', '', '', 'MIDV-259 被猜測的病人塗上春藥後無法停止性交和陰道射精的 Kimeseku 巨乳護士 Fumika Nakayama', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '597', '786', '719', '892', '', '257', '479', '10.0', '6300', '630', '1740423647', '1740372155', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MIDV-259 被猜測的病人塗上春藥後無法停止性交和陰道射精的 Kimeseku 巨乳護士 Fumika Nakayama', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/2b3cb885ed32/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('258', '38', '0', '0', 'BLK-619 把最好的關西方言Gal Rima Arai借給你家！ ！ - 新井リマ', '', 'BLK619bazuihaodeguanxifangyanGalRimaAraijiegeinijiaxinjing', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/31866_cover_2025-02-22_170736.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/31866_cover_2025-02-22_170736.jpg', '', '', '', '', 'BLK-619 把最好的關西方言Gal Rima Arai借給你家！ ！ - 新井リマ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '502', '564', '786', '404', '', '519', '276', '9.0', '540', '60', '1740423647', '1740372695', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BLK-619 把最好的關西方言Gal Rima Arai借給你家！ ！ - 新井リマ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/078343a57e10/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('257', '38', '0', '0', 'HMN-304 在Deriheru，我只口交了兩年，卻因為有女朋友而被巨乳性愛小姐嫉妒。水木彌生 - 彌生美月', '', 'HMN304zaiDeriheruwozhikoujiaoliaoliangnianqueyinweiyounvpengyouerbeijuruxingaixiaojiejidushuimumishengmishengmeiyue', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/98068_cover_2025-02-22_170736.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/98068_cover_2025-02-22_170736.jpg', '', '', '', '', 'HMN-304 在Deriheru，我只口交了兩年，卻因為有女朋友而被巨乳性愛小姐嫉妒。水木彌生 - 彌生美月', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '897', '427', '210', '148', '', '978', '836', '7.0', '6321', '903', '1740423643', '1740373235', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HMN-304 在Deriheru，我只口交了兩年，卻因為有女朋友而被巨乳性愛小姐嫉妒。水木彌生 - 彌生美月', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/02c5268cb940/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('256', '38', '0', '0', 'MVSD-535 帶著治癒的微笑咀嚼！超可愛打手槍美女護士低聲說髒話慢快打手槍帶你進入最佳射精治愈', '', 'MVSD535daizhuzhiyudeweixiaojujiaochaokeaidashouqiangmeinvhushidishengshuizanghuamankuaidashouqiangdainijinruzuijiashejingzhiyu', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/53836_cover_2025-02-22_171106.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/53836_cover_2025-02-22_171106.jpg', '', '', '', '', 'MVSD-535 帶著治癒的微笑咀嚼！超可愛打手槍美女護士低聲說髒話慢快打手槍帶你進入最佳射精治愈', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '13', '690', '827', '511', '', '295', '284', '9.0', '2781', '309', '1740423643', '1740373596', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MVSD-535 帶著治癒的微笑咀嚼！超可愛打手槍美女護士低聲說髒話慢快打手槍帶你進入最佳射精治愈', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/172fdd37c61f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('255', '38', '0', '0', 'MIFD-223 新人AV男優Etch Sweet～非常敏感的西點生AV出道！ ！堂本輕聲 - 堂元ふわり', '', 'MIFD223xinrenAVnanyouEtchSweetfeichangmingandexidianshengAVchudaotangbenqingshengtangyuan', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/32168_cover_2025-02-22_173438.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/32168_cover_2025-02-22_173438.jpg', '', '', '', '', 'MIFD-223 新人AV男優Etch Sweet～非常敏感的西點生AV出道！ ！堂本輕聲 - 堂元ふわり', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '511', '531', '136', '117', '', '990', '745', '5.0', '3575', '715', '1740423643', '1740374135', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MIFD-223 新人AV男優Etch Sweet～非常敏感的西點生AV出道！ ！堂本輕聲 - 堂元ふわり', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/848d5ebeb0f2/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('254', '38', '0', '0', 'BIJN-236 文件高潮性愛與暴露的本能棕色女孩媽媽狂歡樂趣高潮絆倒色情身體蘭卡 - 蘭華', '', 'BIJN236wenjiangaochaoxingaiyubaoludebennengzongsenvhaimamakuanghuanlequgaochaobandaoseqingshentilankalanhua', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/44670_cover_2025-02-22_173608.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/44670_cover_2025-02-22_173608.jpg', '', '', '', '', 'BIJN-236 文件高潮性愛與暴露的本能棕色女孩媽媽狂歡樂趣高潮絆倒色情身體蘭卡 - 蘭華', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '94', '658', '712', '725', '', '302', '1000', '6.0', '4098', '683', '1740423643', '1740374675', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BIJN-236 文件高潮性愛與暴露的本能棕色女孩媽媽狂歡樂趣高潮絆倒色情身體蘭卡 - 蘭華', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/e13e52ebfd24/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('253', '38', '0', '0', 'JUNY-083 對我來說方便的奶嘴寵物它看起來浮華但很聽話敏感巨乳Gradle版黑木玲奈 - 黑木れいな', '', 'JUNY083duiwolaishuifangbiandenaizuichongwutakanqilaifuhuadanhentinghuaminganjuruGradlebanheimulingnaiheimu', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/47543_cover_2025-02-22_173438.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/47543_cover_2025-02-22_173438.jpg', '', '', '', '', 'JUNY-083 對我來說方便的奶嘴寵物它看起來浮華但很聽話敏感巨乳Gradle版黑木玲奈 - 黑木れいな', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '937', '969', '20', '735', '', '1', '820', '9.0', '4977', '553', '1740423643', '1740375215', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUNY-083 對我來說方便的奶嘴寵物它看起來浮華但很聽話敏感巨乳Gradle版黑木玲奈 - 黑木れいな', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/4942d4f786df/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('252', '38', '0', '0', 'BABM-016 Babu Miaru Mitsuki 媽媽稱讚讚美我還活著，所以我要假裝做愛 Mitsuki Yuina - 唯奈みつき', '', 'BABM016BabuMiaruMitsukimamachenzanzanmeiwohuanhuozhusuoyiwoyaojiazhuangzuoaiMitsukiYuinaweinai', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/58462_cover_2025-02-22_173608.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/58462_cover_2025-02-22_173608.jpg', '', '', '', '', 'BABM-016 Babu Miaru Mitsuki 媽媽稱讚讚美我還活著，所以我要假裝做愛 Mitsuki Yuina - 唯奈みつき', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '114', '506', '254', '330', '', '967', '603', '2.0', '848', '424', '1740423643', '1740375756', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BABM-016 Babu Miaru Mitsuki 媽媽稱讚讚美我還活著，所以我要假裝做愛 Mitsuki Yuina - 唯奈みつき', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9f9f4f60314f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('251', '38', '0', '0', 'KSBJ-231 家庭事務~我的姐夫和我的通姦~安娜 - 杏奈', '', 'KSBJ231jiatingshiwuwodejiefuhewodetongjianannaxingnai', '1', 'K', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/68746_cover_2025-02-22_173608.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/68746_cover_2025-02-22_173608.jpg', '', '', '', '', 'KSBJ-231 家庭事務~我的姐夫和我的通姦~安娜 - 杏奈', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '125', '248', '207', '14', '', '458', '751', '4.0', '1464', '366', '1740423643', '1740376295', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'KSBJ-231 家庭事務~我的姐夫和我的通姦~安娜 - 杏奈', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/09edfc16c8ac/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('250', '38', '0', '0', 'EBOD-956 當剛搬到東京的超溫柔小gal脫下H罩杯！ AV 登場 新山千夏 - 新山ちなつ', '', 'EBOD956danggangbandaodongjingdechaowenrouxiaogaltuoxiaHzhaobeiAVdengchangxinshanqianxiaxinshan', '1', 'E', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/13072_cover_2025-02-22_173438.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/13072_cover_2025-02-22_173438.jpg', '', '', '', '', 'EBOD-956 當剛搬到東京的超溫柔小gal脫下H罩杯！ AV 登場 新山千夏 - 新山ちなつ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '76', '366', '194', '102', '', '12', '398', '4.0', '3004', '751', '1740423643', '1740376835', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'EBOD-956 當剛搬到東京的超溫柔小gal脫下H罩杯！ AV 登場 新山千夏 - 新山ちなつ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/e71ff5dde112/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('249', '38', '0', '0', 'MESU-106 在酒店工作的慕男狂門房中出客服吉井美紀 - 吉井美希 (伊澤涼子、吉井美希)', '', 'MESU106zaijiudiangongzuodemunankuangmenfangzhongchukefujijingmeijijijingmeixiyizeliangzijijingmeixi', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/88546_cover_2025-02-22_180340.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/88546_cover_2025-02-22_180340.jpg', '', '', '', '', 'MESU-106 在酒店工作的慕男狂門房中出客服吉井美紀 - 吉井美希 (伊澤涼子、吉井美希)', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '761', '528', '648', '970', '', '783', '722', '8.0', '5792', '724', '1740423643', '1740377195', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MESU-106 在酒店工作的慕男狂門房中出客服吉井美紀 - 吉井美希 (伊澤涼子、吉井美希)', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/966e55b27c0c/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('248', '38', '0', '0', 'BBTU-054 排殺！ Ahegao 巨乳精液顏射愛麗絲木崎 - 希咲アリス', '', 'BBTU054paishaAhegaojurujingyeyansheailisimuqixixiao', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/68593_cover_2025-02-22_180340.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/68593_cover_2025-02-22_180340.jpg', '', '', '', '', 'BBTU-054 排殺！ Ahegao 巨乳精液顏射愛麗絲木崎 - 希咲アリス', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '189', '390', '910', '733', '', '653', '381', '7.0', '728', '104', '1740423643', '1740377735', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BBTU-054 排殺！ Ahegao 巨乳精液顏射愛麗絲木崎 - 希咲アリス', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/d215147ebe51/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('247', '38', '0', '0', 'GOUL-001 【鎌倉海難波】模特級風範的女神降臨巨乳美乳在私人別墅亂交清酒池肉林！', '', 'GOUL001liancanghainanbomotejifengfandenvshenjianglinjurumeiruzaisirenbieshuluanjiaoqingjiuchiroulin', '1', 'G', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/11443_cover_2025-02-22_181141.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/11443_cover_2025-02-22_181141.jpg', '', '', '', '', 'GOUL-001 【鎌倉海難波】模特級風範的女神降臨巨乳美乳在私人別墅亂交清酒池肉林！', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '71', '729', '477', '803', '', '254', '541', '10.0', '5670', '567', '1740423643', '1740378275', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'GOUL-001 【鎌倉海難波】模特級風範的女神降臨巨乳美乳在私人別墅亂交清酒池肉林！', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/b352efc1c14f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('246', '38', '0', '0', 'MTALL-051 [試著讓你的大腦活著？] 最好的自慰 ASMR 讓你的大腦和蛋蛋與小惡魔白痴一起融化 - 白桃花', '', 'MTALL051shizhurangnidedanaohuozhuzuihaodeziweiASMRrangnidedanaohedandanyuxiaoemobaichiyiqironghuabaitaohua', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/85007_cover_2025-02-22_181141.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/85007_cover_2025-02-22_181141.jpg', '', '', '', '', 'MTALL-051 [試著讓你的大腦活著？] 最好的自慰 ASMR 讓你的大腦和蛋蛋與小惡魔白痴一起融化 - 白桃花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '141', '360', '715', '688', '', '335', '781', '5.0', '4175', '835', '1740423643', '1740378815', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MTALL-051 [試著讓你的大腦活著？] 最好的自慰 ASMR 讓你的大腦和蛋蛋與小惡魔白痴一起融化 - 白桃花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/2f8e47f5f485/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('245', '38', '0', '0', 'BBTU-053 豐滿男孩~媽媽吃丸子 Yuri Oshikawa - 推川悠里', '', 'BBTU053fengmannanhaimamachiwanziYuriOshikawatuichuanyouli', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/12428_cover_2025-02-22_180340.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/12428_cover_2025-02-22_180340.jpg', '', '', '', '', 'BBTU-053 豐滿男孩~媽媽吃丸子 Yuri Oshikawa - 推川悠里', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '539', '715', '974', '664', '', '892', '456', '2.0', '350', '175', '1740423643', '1740379355', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BBTU-053 豐滿男孩~媽媽吃丸子 Yuri Oshikawa - 推川悠里', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/68bf455b8c77/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('243', '38', '0', '0', 'VENX-194 白木裕子 - 白木優子', '', 'VENX194baimuyuzibaimuyouzi', '1', 'V', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/61701_cover_2025-02-22_183012.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/61701_cover_2025-02-22_183012.jpg', '', '', '', '', 'VENX-194 白木裕子 - 白木優子', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '306', '842', '458', '252', '', '565', '636', '9.0', '3132', '348', '1740423643', '1740380437', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'VENX-194 白木裕子 - 白木優子', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/746a56373824/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('244', '38', '0', '0', 'NACR-625 我父親的第二任妻子是個淫蕩的蕩婦。白川花生 - 白河花清', '', 'NACR625wofuqindedierrenqizishigeyindangdedangfubaichuanhuashengbaihehuaqing', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/57188_cover_2025-02-22_181141.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/57188_cover_2025-02-22_181141.jpg', '', '', '', '', 'NACR-625 我父親的第二任妻子是個淫蕩的蕩婦。白川花生 - 白河花清', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '969', '626', '86', '592', '', '142', '390', '4.0', '3884', '971', '1740423643', '1740379835', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NACR-625 我父親的第二任妻子是個淫蕩的蕩婦。白川花生 - 白河花清', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/cebbd4705837/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('242', '38', '0', '0', 'KIR-062 戲弄上司並阻止射精的辦公室女郎Kishiwamizu - 岸和水', '', 'KIR062xinongshangsibingzuzhishejingdebangongshinvlangKishiwamizuanheshui', '1', 'K', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/86556_cover_2025-02-22_183442.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/86556_cover_2025-02-22_183442.jpg', '', '', '', '', 'KIR-062 戲弄上司並阻止射精的辦公室女郎Kishiwamizu - 岸和水', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '746', '156', '325', '640', '', '252', '757', '1.0', '940', '940', '1740423643', '1740380795', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'KIR-062 戲弄上司並阻止射精的辦公室女郎Kishiwamizu - 岸和水', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/009be4ca7e82/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('241', '38', '0', '0', 'NACR-624 發情妻子織田真子', '', 'NACR624faqingqizizhitianzhenzi', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/81843_cover_2025-02-22_183442.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/81843_cover_2025-02-22_183442.jpg', '', '', '', '', 'NACR-624 發情妻子織田真子', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '635', '153', '534', '699', '', '785', '562', '7.0', '4739', '677', '1740423643', '1740381335', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NACR-624 發情妻子織田真子', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/26b264afc568/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('240', '38', '0', '0', 'ABW-316 沉迷於色欲的文科少女。粘稠的高濕度無聲性愛Asuna Kawai - 河合明日菜', '', 'ABW316chenmiyuseyudewenkeshaonvzhanchoudegaoshiduwushengxingaiAsunaKawaihehemingricai', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/95218_cover_2025-02-22_183012.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/95218_cover_2025-02-22_183012.jpg', '', '', '', '', 'ABW-316 沉迷於色欲的文科少女。粘稠的高濕度無聲性愛Asuna Kawai - 河合明日菜', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '354', '221', '970', '176', '', '700', '301', '4.0', '1348', '337', '1740423643', '1740381875', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ABW-316 沉迷於色欲的文科少女。粘稠的高濕度無聲性愛Asuna Kawai - 河合明日菜', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/c0d03843d1b5/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('238', '38', '0', '0', 'CRDD-024 我的女朋友是西方金髮美少女個人拍攝播種亞洲精液Stella', '', 'CRDD024wodenvpengyoushixifangjinfameishaonvgerenpaishebozhongyazhoujingyeStella', '1', 'C', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/35992_cover_2025-02-22_185714.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/35992_cover_2025-02-22_185714.jpg', '', '', '', '', 'CRDD-024 我的女朋友是西方金髮美少女個人拍攝播種亞洲精液Stella', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '213', '673', '916', '238', '', '425', '399', '8.0', '1472', '184', '1740423643', '1740382895', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'CRDD-024 我的女朋友是西方金髮美少女個人拍攝播種亞洲精液Stella', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/6dcba137a124/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('239', '38', '0', '0', 'AMBI-163 Only For Me 學校泳裝M美少女真白實裡 - 真白みのり', '', 'AMBI163OnlyForMexuexiaoyongzhuangMmeishaonvzhenbaishilizhenbai', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/87943_cover_2025-02-22_183442.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/87943_cover_2025-02-22_183442.jpg', '', '', '', '', 'AMBI-163 Only For Me 學校泳裝M美少女真白實裡 - 真白みのり', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '371', '460', '880', '608', '', '456', '807', '7.0', '2009', '287', '1740423643', '1740382415', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'AMBI-163 Only For Me 學校泳裝M美少女真白實裡 - 真白みのり', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/82bc31f6985a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('236', '38', '0', '0', 'ABW-317 永無止境的陰道射精性愛。 18 連續內射精 和久井美宇 - 和久井美兎', '', 'ABW317yongwuzhijingdeyindaoshejingxingai18lianxuneishejinghejiujingmeiyuhejiujingmeitu', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/29497_cover_2025-02-22_183012.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/29497_cover_2025-02-22_183012.jpg', '', '', '', '', 'ABW-317 永無止境的陰道射精性愛。 18 連續內射精 和久井美宇 - 和久井美兎', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '109', '403', '794', '765', '', '28', '459', '5.0', '3860', '772', '1740423640', '1740384035', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ABW-317 永無止境的陰道射精性愛。 18 連續內射精 和久井美宇 - 和久井美兎', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/594c5e9edbc7/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('237', '38', '0', '0', 'JUQ-189 《親愛的，這樣真的好嗎……？》讓部下擁抱愛妻小早川玲子的我的網易故事 - 小早川怜子', '', 'JUQ189qinaidezheyangzhendehaomarangbuxiayongbaoaiqixiaozaochuanlingzidewodewangyigushixiaozaochuanlianzi', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/46465_cover_2025-02-22_185714.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/46465_cover_2025-02-22_185714.jpg', '', '', '', '', 'JUQ-189 《親愛的，這樣真的好嗎……？》讓部下擁抱愛妻小早川玲子的我的網易故事 - 小早川怜子', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '889', '745', '596', '376', '', '768', '462', '2.0', '720', '360', '1740423640', '1740383495', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUQ-189 《親愛的，這樣真的好嗎……？》讓部下擁抱愛妻小早川玲子的我的網易故事 - 小早川怜子', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/50f569ba0239/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('235', '38', '0', '0', 'NACR-626 如果你調用它，它會馬上過來，讓你做任何事情！ ？服從佐世子醬！ ！穗香愛理 - 穗花あいり', '', 'NACR626ruguonidiaoyongtatahuimashangguolairangnizuorenheshiqingfucongzuoshizijiangsuixiangailisuihua', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/18067_cover_2025-02-22_185714.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/18067_cover_2025-02-22_185714.jpg', '', '', '', '', 'NACR-626 如果你調用它，它會馬上過來，讓你做任何事情！ ？服從佐世子醬！ ！穗香愛理 - 穗花あいり', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '28', '148', '474', '538', '', '119', '665', '4.0', '44', '11', '1740423640', '1740384395', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NACR-626 如果你調用它，它會馬上過來，讓你做任何事情！ ？服從佐世子醬！ ！穗香愛理 - 穗花あいり', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a16dfb4f0fb7/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('234', '38', '0', '0', 'HUNTB-465 喜歡色情漫畫的御宅族大嫂和她的朋友用我的肉棒進行二次元狂歡！突如其來的小姑子，', '', 'HUNTB465xihuanseqingmanhuadeyuzhaizudasaohetadepengyouyongwoderoubangjinxingerciyuankuanghuanturuqilaidexiaoguzi', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/71289_cover_2025-02-22_191646.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/71289_cover_2025-02-22_191646.jpg', '', '', '', '', 'HUNTB-465 喜歡色情漫畫的御宅族大嫂和她的朋友用我的肉棒進行二次元狂歡！突如其來的小姑子，', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '878', '33', '160', '150', '', '496', '643', '6.0', '5766', '961', '1740423640', '1740384937', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HUNTB-465 喜歡色情漫畫的御宅族大嫂和她的朋友用我的肉棒進行二次元狂歡！突如其來的小姑子，', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/900b3c28a27e/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('233', '38', '0', '0', 'HUNTB-461 小姑子的體力運動裝太色情了！如果你受不了就攻擊它，你不會拒絕它', '', 'HUNTB461xiaoguzidetiliyundongzhuangtaiseqingliaoruguonishoubuliaojiugongjitanibuhuijujueta', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/28110_cover_2025-02-22_191646.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/28110_cover_2025-02-22_191646.jpg', '', '', '', '', 'HUNTB-461 小姑子的體力運動裝太色情了！如果你受不了就攻擊它，你不會拒絕它', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '509', '410', '269', '947', '', '572', '213', '8.0', '7080', '885', '1740423640', '1740385475', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HUNTB-461 小姑子的體力運動裝太色情了！如果你受不了就攻擊它，你不會拒絕它', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/5abb95a8cc0d/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('231', '38', '0', '0', 'NACR-627 我愛暨！臟女孩免費！ ！流川里約 - 流川莉央', '', 'NACR627woaijizangnvhaimianfeiliuchuanliyueliuchuanliyang', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/78511_cover_2025-02-22_191646.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/78511_cover_2025-02-22_191646.jpg', '', '', '', '', 'NACR-627 我愛暨！臟女孩免費！ ！流川里約 - 流川莉央', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '862', '108', '697', '246', '', '310', '338', '6.0', '684', '114', '1740423640', '1740386555', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NACR-627 我愛暨！臟女孩免費！ ！流川里約 - 流川莉央', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/89f55a8cafbe/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('232', '38', '0', '0', 'VENX-195 筱田優2天1夜被突然闖入的嫂子追上 - 篠田優', '', 'VENX195xiaotianyou2tian1yebeituranchuangrudesaozizhuishangxiaotianyou', '1', 'V', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/47369_cover_2025-02-22_192546.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/47369_cover_2025-02-22_192546.jpg', '', '', '', '', 'VENX-195 筱田優2天1夜被突然闖入的嫂子追上 - 篠田優', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '882', '608', '324', '606', '', '52', '367', '8.0', '3528', '441', '1740423640', '1740385955', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'VENX-195 筱田優2天1夜被突然闖入的嫂子追上 - 篠田優', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9a711ea20f02/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('230', '38', '0', '0', 'JUQ-171 這是一個性騷擾對下屬要求嚴格的女上司，結果非但沒有被罵，還能和她上床的故事。春菜花', '', 'JUQ171zheshiyigexingsaoraoduixiazhuyaoqiuyangedenvshangsijieguofeidanmeiyoubeimahuannenghetashangchuangdegushichuncaihua', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/70713_cover_2025-02-22_192546.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/70713_cover_2025-02-22_192546.jpg', '', '', '', '', 'JUQ-171 這是一個性騷擾對下屬要求嚴格的女上司，結果非但沒有被罵，還能和她上床的故事。春菜花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '834', '477', '601', '546', '', '586', '372', '2.0', '720', '360', '1740423640', '1740387095', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUQ-171 這是一個性騷擾對下屬要求嚴格的女上司，結果非但沒有被罵，還能和她上床的故事。春菜花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a2929babdcdd/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('229', '38', '0', '0', 'ROYD-117 一揉妹妹裸露的丰乳，就太合不來了，越界了。綾瀨心 - 綾瀬こころ', '', 'ROYD117yiroumeimeiluoludefengrujiutaihebulailiaoyuejieliaolinglaixinlinglai', '1', 'R', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/30191_cover_2025-02-22_192546.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/30191_cover_2025-02-22_192546.jpg', '', '', '', '', 'ROYD-117 一揉妹妹裸露的丰乳，就太合不來了，越界了。綾瀨心 - 綾瀬こころ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '669', '212', '562', '892', '', '427', '695', '3.0', '2949', '983', '1740423640', '1740387575', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ROYD-117 一揉妹妹裸露的丰乳，就太合不來了，越界了。綾瀨心 - 綾瀬こころ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9f8f31b9cfef/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('228', '38', '0', '0', 'HMN-309 美乳Pururun智能私人家教反向3P乳交中出講座訓練姬破至無雙惠奈小梅一香南條 - 小梅惠奈', '', 'HMN309meiruPururunzhinengsirenjiajiaofanxiang3Prujiaozhongchujiangzuoxunlianjipozhiwushuanghuinaixiaomeiyixiangnantiaoxiaomeihuinai', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/36633_cover_2025-02-22_194518.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/36633_cover_2025-02-22_194518.jpg', '', '', '', '', 'HMN-309 美乳Pururun智能私人家教反向3P乳交中出講座訓練姬破至無雙惠奈小梅一香南條 - 小梅惠奈', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '812', '453', '189', '834', '', '594', '96', '9.0', '7794', '866', '1740423640', '1740387995', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HMN-309 美乳Pururun智能私人家教反向3P乳交中出講座訓練姬破至無雙惠奈小梅一香南條 - 小梅惠奈', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/849cc76dac3a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('227', '38', '0', '0', 'DASS-102 新岳父是禁忌的Kimoota！ ？ Amiri Saito，一個嚴重的Gal Idol 陷入絕望的粘性中出性沼澤', '', 'DASS102xinyuefushijinjideKimootaAmiriSaitoyigeyanzhongdeGalIdolxianrujuewangdezhanxingzhongchuxingzhaoze', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/73452_cover_2025-02-22_194948.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/73452_cover_2025-02-22_194948.jpg', '', '', '', '', 'DASS-102 新岳父是禁忌的Kimoota！ ？ Amiri Saito，一個嚴重的Gal Idol 陷入絕望的粘性中出性沼澤', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '934', '489', '437', '350', '', '531', '877', '6.0', '132', '22', '1740423640', '1740388535', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DASS-102 新岳父是禁忌的Kimoota！ ？ Amiri Saito，一個嚴重的Gal Idol 陷入絕望的粘性中出性沼澤', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/bc671be30eda/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('226', '38', '0', '0', 'DASS-103 一個飢渴的已婚女教師一遍又一遍地不純潔地和她的學生交集，說“只有這一次”。黑川堇', '', 'DASS103yigejikedeyihunnvjiaoshiyibianyouyibiandibuchunjiedihetadexueshengjiaojishuizhiyouzheyiciheichuanjin', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/86582_cover_2025-02-22_194518.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/86582_cover_2025-02-22_194518.jpg', '', '', '', '', 'DASS-103 一個飢渴的已婚女教師一遍又一遍地不純潔地和她的學生交集，說“只有這一次”。黑川堇', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '498', '912', '263', '504', '', '443', '969', '6.0', '3564', '594', '1740423640', '1740389075', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DASS-103 一個飢渴的已婚女教師一遍又一遍地不純潔地和她的學生交集，說“只有這一次”。黑川堇', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/4859e31c0c8f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('225', '38', '0', '0', 'DASS-099 一個身材苗條的大屁股女友，被我爸拿下，被種草壓著。尾崎繪梨香 - 尾崎えりか', '', 'DASS099yigeshencaimiaotiaodedapigunvyoubeiwobanaxiabeizhongcaoyazhuweiqihuilixiangweiqi', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/37555_cover_2025-02-22_194948.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/37555_cover_2025-02-22_194948.jpg', '', '', '', '', 'DASS-099 一個身材苗條的大屁股女友，被我爸拿下，被種草壓著。尾崎繪梨香 - 尾崎えりか', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '628', '96', '969', '296', '', '518', '557', '6.0', '4500', '750', '1740423640', '1740389615', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DASS-099 一個身材苗條的大屁股女友，被我爸拿下，被種草壓著。尾崎繪梨香 - 尾崎えりか', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/bdbab01ee51b/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('224', '38', '0', '0', 'CJOD-367 無限射精泡泡浴場 Yuri Honma - 本真友裡', '', 'CJOD367wuxianshejingpaopaoyuchangYuriHonmabenzhenyouli', '1', 'C', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/15979_cover_2025-02-22_194518.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/15979_cover_2025-02-22_194518.jpg', '', '', '', '', 'CJOD-367 無限射精泡泡浴場 Yuri Honma - 本真友裡', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '496', '644', '467', '648', '', '255', '397', '5.0', '180', '36', '1740423640', '1740390155', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'CJOD-367 無限射精泡泡浴場 Yuri Honma - 本真友裡', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/bbe732fb2f89/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('223', '38', '0', '0', 'ROYD-116 早上起床房間裡有浴衣的初級女職員！她總是很野蠻和咒罵，但我已經被寵壞了', '', 'ROYD116zaoshangqichuangfangjianliyouyuyidechujinvzhiyuantazongshihenyemanhezhoumadanwoyijingbeichonghuailiao', '1', 'R', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/11259_cover_2025-02-22_194948.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/11259_cover_2025-02-22_194948.jpg', '', '', '', '', 'ROYD-116 早上起床房間裡有浴衣的初級女職員！她總是很野蠻和咒罵，但我已經被寵壞了', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '570', '801', '545', '376', '', '733', '87', '1.0', '317', '317', '1740423640', '1740390695', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ROYD-116 早上起床房間裡有浴衣的初級女職員！她總是很野蠻和咒罵，但我已經被寵壞了', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/5e72e9508c02/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('222', '38', '0', '0', 'URE-089 原作：Go Tama 美滿生活～被盯上的清醒妻子～人妻幸福日常的忠實真人實拍！ ！黑川堇', '', 'URE089yuanzuoGoTamameimanshenghuobeidingshangdeqingxingqizirenqixingfurichangdezhongshizhenrenshipaiheichuanjin', '1', 'U', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/53874_cover_2025-02-22_201221.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/53874_cover_2025-02-22_201221.jpg', '', '', '', '', 'URE-089 原作：Go Tama 美滿生活～被盯上的清醒妻子～人妻幸福日常的忠實真人實拍！ ！黑川堇', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '176', '333', '311', '376', '', '539', '183', '5.0', '2545', '509', '1740423640', '1740391175', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'URE-089 原作：Go Tama 美滿生活～被盯上的清醒妻子～人妻幸福日常的忠實真人實拍！ ！黑川堇', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9b3efb848846/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('221', '38', '0', '0', 'SSIS-776 厭惡性騷擾的上司安排的出差合租房……極度淫蕩後背污垢暴露的巨乳新人OL一夜淪為肉鬼 - うんぱい', '', 'SSIS776yanexingsaoraodeshangsianpaidechuchahezufangjiduyindanghoubeiwugoubaoludejuruxinrenOLyiyelunweirougui', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/51957_cover_2025-02-22_201221.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/51957_cover_2025-02-22_201221.jpg', '', '', '', '', 'SSIS-776 厭惡性騷擾的上司安排的出差合租房……極度淫蕩後背污垢暴露的巨乳新人OL一夜淪為肉鬼 - うんぱい', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '366', '431', '665', '866', '', '504', '976', '5.0', '4890', '978', '1740423640', '1740391595', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-776 厭惡性騷擾的上司安排的出差合租房……極度淫蕩後背污垢暴露的巨乳新人OL一夜淪為肉鬼 - うんぱい', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/816e056ce2ac/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('220', '38', '0', '0', 'SSIS-600 每天晚上乾著在自助洗衣店睡著的手無寸鐵的老婆幹到洗完星宮一花', '', 'SSIS600meitianwanshangqianzhuzaizizhuxiyidianshuizhudeshouwucuntiedelaopogandaoxiwanxinggongyihua', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/49594_cover_2025-02-22_201951.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/49594_cover_2025-02-22_201951.jpg', '', '', '', '', 'SSIS-600 每天晚上乾著在自助洗衣店睡著的手無寸鐵的老婆幹到洗完星宮一花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '796', '226', '625', '771', '', '821', '612', '6.0', '5748', '958', '1740423640', '1740392135', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-600 每天晚上乾著在自助洗衣店睡著的手無寸鐵的老婆幹到洗完星宮一花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/caba8f1937d1/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('219', '38', '0', '0', 'SSIS-585 神之巨乳的質感，不容錯過的壓倒性影像美感一瞬間的抖動4K拍攝Jcup戀物視頻密集性高潮', '', 'SSIS585shenzhijurudezhiganburongcuoguodeyadaoxingyingxiangmeiganyishunjiandedoudong4KpaisheJcuplianwushipinmijixinggaochao', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/43509_cover_2025-02-22_201951.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/43509_cover_2025-02-22_201951.jpg', '', '', '', '', 'SSIS-585 神之巨乳的質感，不容錯過的壓倒性影像美感一瞬間的抖動4K拍攝Jcup戀物視頻密集性高潮', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '825', '810', '822', '4', '', '872', '229', '5.0', '3135', '627', '1740423640', '1740392676', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-585 神之巨乳的質感，不容錯過的壓倒性影像美感一瞬間的抖動4K拍攝Jcup戀物視頻密集性高潮', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/10c763dca0f0/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('218', '38', '0', '0', 'HMN-310 Always Whispering In your Ear Anphrodisiac Kimeseku 骯髒說話的蕩婦腦蟲后宮中出反轉 3P', '', 'HMN310AlwaysWhisperingInyourEarAnphrodisiacKimesekuangzangshuihuadedangfunaochonghougongzhongchufanzhuan3P', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/70015_cover_2025-02-22_201221.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/70015_cover_2025-02-22_201221.jpg', '', '', '', '', 'HMN-310 Always Whispering In your Ear Anphrodisiac Kimeseku 骯髒說話的蕩婦腦蟲后宮中出反轉 3P', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '231', '405', '990', '672', '', '764', '519', '7.0', '749', '107', '1740423640', '1740393215', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HMN-310 Always Whispering In your Ear Anphrodisiac Kimeseku 骯髒說話的蕩婦腦蟲后宮中出反轉 3P', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/8ce108394c10/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('217', '38', '0', '0', 'SSIS-649 鬱悶已過頂峰，流盡體液，毫無必要地高潮。 - 架乃由羅', '', 'SSIS649yumenyiguodingfengliujintiyehaowubiyaodigaochaojianaiyouluo', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/73668_cover_2025-02-22_201951.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/73668_cover_2025-02-22_201951.jpg', '', '', '', '', 'SSIS-649 鬱悶已過頂峰，流盡體液，毫無必要地高潮。 - 架乃由羅', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '185', '172', '47', '624', '', '447', '239', '7.0', '5999', '857', '1740423636', '1740393755', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-649 鬱悶已過頂峰，流盡體液，毫無必要地高潮。 - 架乃由羅', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/f4d6dec4a4c7/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('216', '38', '0', '0', 'SSIS-589 出道1週年特輯SSS-BODY 苗條豐滿的極品美女驚艷世界的愛欲 山手梨雅 - 山手梨愛', '', 'SSIS589chudao1zhouniantejiSSSBODYmiaotiaofengmandejipinmeinvjingyanshijiedeaiyushanshouliyashanshouliai', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/16607_cover_2025-02-22_204123.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/16607_cover_2025-02-22_204123.jpg', '', '', '', '', 'SSIS-589 出道1週年特輯SSS-BODY 苗條豐滿的極品美女驚艷世界的愛欲 山手梨雅 - 山手梨愛', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '245', '831', '289', '985', '', '420', '277', '6.0', '3438', '573', '1740423636', '1740394297', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SSIS-589 出道1週年特輯SSS-BODY 苗條豐滿的極品美女驚艷世界的愛欲 山手梨雅 - 山手梨愛', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/09acbabef8bf/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('215', '38', '0', '0', 'GVH-503 母嬰強姦 Saran Ito - 伊東沙蘭', '', 'GVH503muyingqiangjianSaranItoyidongshalan', '1', 'G', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/32572_cover_2025-02-22_204654.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/32572_cover_2025-02-22_204654.jpg', '', '', '', '', 'GVH-503 母嬰強姦 Saran Ito - 伊東沙蘭', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '743', '474', '570', '129', '', '993', '435', '5.0', '1400', '280', '1740423636', '1740394835', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'GVH-503 母嬰強姦 Saran Ito - 伊東沙蘭', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/cd9f02aea55b/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('214', '38', '0', '0', 'RAPD-006 野外強姦 深山強精神病患者 被惡魔襲擊的已婚婦女，儘管她們哭著哭著徒勞 原美織', '', 'RAPD006yewaiqiangjianshenshanqiangjingshenbinghuanzhebeiemoxijideyihunfunvjinguantamenkuzhukuzhutulaoyuanmeizhi', '1', 'R', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/95594_cover_2025-02-22_204123.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/95594_cover_2025-02-22_204123.jpg', '', '', '', '', 'RAPD-006 野外強姦 深山強精神病患者 被惡魔襲擊的已婚婦女，儘管她們哭著哭著徒勞 原美織', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '883', '885', '758', '181', '', '132', '405', '2.0', '470', '235', '1740423636', '1740395195', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'RAPD-006 野外強姦 深山強精神病患者 被惡魔襲擊的已婚婦女，儘管她們哭著哭著徒勞 原美織', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/1e8ad3df28cc/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('213', '38', '0', '0', 'JUE-012 女忍：復仇的陷阱 陵墓淪陷 敵人的魔法隕落和他的部下 Chisato Shoda 的背叛 - 翔田千里', '', 'JUE012nvrenfuchoudexianjinglingmulunxiandirendemofayunluohetadebuxiaChisatoShodadebeipanxiangtianqianli', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/87578_cover_2025-02-22_204654.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/87578_cover_2025-02-22_204654.jpg', '', '', '', '', 'JUE-012 女忍：復仇的陷阱 陵墓淪陷 敵人的魔法隕落和他的部下 Chisato Shoda 的背叛 - 翔田千里', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '504', '107', '230', '223', '', '88', '76', '3.0', '1482', '494', '1740423636', '1740395735', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JUE-012 女忍：復仇的陷阱 陵墓淪陷 敵人的魔法隕落和他的部下 Chisato Shoda 的背叛 - 翔田千里', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/1945605ea674/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('212', '38', '0', '0', 'JSOP-022 新的和美麗的成熟女人澡堂豐富潮濕的豪華肥皂三原咲子 - 美原咲子', '', 'JSOP022xindehemeilidechengshunvrenzaotangfengfuchaoshidehaohuafeizaosanyuanxiaozimeiyuanxiaozi', '1', 'J', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/92068_cover_2025-02-22_204654.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/92068_cover_2025-02-22_204654.jpg', '', '', '', '', 'JSOP-022 新的和美麗的成熟女人澡堂豐富潮濕的豪華肥皂三原咲子 - 美原咲子', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '411', '515', '562', '597', '', '449', '493', '8.0', '680', '85', '1740423636', '1740396275', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'JSOP-022 新的和美麗的成熟女人澡堂豐富潮濕的豪華肥皂三原咲子 - 美原咲子', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/2099648caf29/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('211', '38', '0', '0', 'NSFS-157 從早到晚被當成性慾工具的妻子 情侶人質劫持案VOL.3 - 紺野光', '', 'NSFS157congzaodaowanbeidangchengxingyugongjudeqiziqinglvrenzhijiechianVOL3ganyeguang', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/76238_cover_2025-02-22_204123.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/76238_cover_2025-02-22_204123.jpg', '', '', '', '', 'NSFS-157 從早到晚被當成性慾工具的妻子 情侶人質劫持案VOL.3 - 紺野光', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '373', '216', '850', '768', '', '500', '151', '1.0', '449', '449', '1740423636', '1740396815', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NSFS-157 從早到晚被當成性慾工具的妻子 情侶人質劫持案VOL.3 - 紺野光', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/9e56a1bdc6e3/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('209', '38', '0', '0', 'ALDN-119 同學聚會後... Megu Mio - 三尾めぐ', '', 'ALDN119tongxuejuhuihouMeguMiosanwei', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/66156_cover_2025-02-22_211026.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/66156_cover_2025-02-22_211026.jpg', '', '', '', '', 'ALDN-119 同學聚會後... Megu Mio - 三尾めぐ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '214', '639', '686', '557', '', '674', '441', '6.0', '3168', '528', '1740423636', '1740397895', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-119 同學聚會後... Megu Mio - 三尾めぐ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/100d6551b509/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('210', '38', '0', '0', 'ALDN-118 保險業姨媽的誘惑正田千里 - 翔田千里', '', 'ALDN118baoxianyeyimadeyouhuozhengtianqianlixiangtianqianli', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/45385_cover_2025-02-22_211026.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/45385_cover_2025-02-22_211026.jpg', '', '', '', '', 'ALDN-118 保險業姨媽的誘惑正田千里 - 翔田千里', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '225', '39', '644', '29', '', '827', '115', '4.0', '1132', '283', '1740423636', '1740397295', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-118 保險業姨媽的誘惑正田千里 - 翔田千里', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a06213f9b08a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('208', '38', '0', '0', 'ALDN-120 幸運大叔 新村明里 - 新村晶', '', 'ALDN120xingyundashuxincunminglixincunjing', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/63703_cover_2025-02-22_211026.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/63703_cover_2025-02-22_211026.jpg', '', '', '', '', 'ALDN-120 幸運大叔 新村明里 - 新村晶', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '652', '404', '317', '290', '', '781', '993', '10.0', '6760', '676', '1740423636', '1740398435', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-120 幸運大叔 新村明里 - 新村晶', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/d6eb572ce271/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('207', '38', '0', '0', 'BDA-170 捆綁酷刑覺醒藝人才藝禁閉育苗和香美園 - 美園和花', '', 'BDA170kunbangkuxingjuexingyirencaiyijinbiyumiaohexiangmeiyuanmeiyuanhehua', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/27267_cover_2025-02-22_211756.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/27267_cover_2025-02-22_211756.jpg', '', '', '', '', 'BDA-170 捆綁酷刑覺醒藝人才藝禁閉育苗和香美園 - 美園和花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '871', '209', '163', '554', '', '715', '480', '5.0', '2570', '514', '1740423636', '1740398795', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BDA-170 捆綁酷刑覺醒藝人才藝禁閉育苗和香美園 - 美園和花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/5b8af10834fd/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('205', '38', '0', '0', 'ALDN-116 Tabiji 母子的兩次旅行 Aya Kabana - 花撫あや', '', 'ALDN116TabijimuzideliangcilvxingAyaKabanahuafu', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/56777_cover_2025-02-22_211756.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/56777_cover_2025-02-22_211756.jpg', '', '', '', '', 'ALDN-116 Tabiji 母子的兩次旅行 Aya Kabana - 花撫あや', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '602', '422', '249', '924', '', '687', '799', '4.0', '792', '198', '1740423636', '1740399875', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-116 Tabiji 母子的兩次旅行 Aya Kabana - 花撫あや', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/fdc7b3947762/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('206', '38', '0', '0', 'ALDN-117 連我婆婆都想懷孕。真的 - 本真友裡', '', 'ALDN117lianwopopoduxianghuaiyunzhendebenzhenyouli', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/32035_cover_2025-02-22_211756.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/32035_cover_2025-02-22_211756.jpg', '', '', '', '', 'ALDN-117 連我婆婆都想懷孕。真的 - 本真友裡', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '322', '404', '520', '28', '', '166', '887', '3.0', '2229', '743', '1740423636', '1740399335', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-117 連我婆婆都想懷孕。真的 - 本真友裡', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/27fab5d3ab38/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('203', '38', '0', '0', 'ALDN-115 當時我朋友的朋友……小松杏，我朋友的媽媽', '', 'ALDN115dangshiwopengyoudepengyouxiaosongxingwopengyoudemama', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/76332_cover_2025-02-22_213458.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/76332_cover_2025-02-22_213458.jpg', '', '', '', '', 'ALDN-115 當時我朋友的朋友……小松杏，我朋友的媽媽', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '99', '689', '426', '128', '', '650', '81', '6.0', '4278', '713', '1740423636', '1740400955', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ALDN-115 當時我朋友的朋友……小松杏，我朋友的媽媽', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/33fc094c774a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('204', '38', '0', '0', 'MADM-164 [4K] 鄰居NTR被隔壁無敵雞巴勾引…老公出差巨乳豐滿人妻被鄰居的粗屌寶田夢波淹沒 - 寶田望愛實', '', 'MADM1644KlinjuNTRbeigebiwudijibagouyinlaogongchuchajurufengmanrenqibeilinjudecudiaobaotianmengboyanmeibaotianwangaishi', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/46255_cover_2025-02-22_213458.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/46255_cover_2025-02-22_213458.jpg', '', '', '', '', 'MADM-164 [4K] 鄰居NTR被隔壁無敵雞巴勾引…老公出差巨乳豐滿人妻被鄰居的粗屌寶田夢波淹沒 - 寶田望愛實', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '323', '189', '940', '65', '', '68', '95', '6.0', '4188', '698', '1740423636', '1740400355', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MADM-164 [4K] 鄰居NTR被隔壁無敵雞巴勾引…老公出差巨乳豐滿人妻被鄰居的粗屌寶田夢波淹沒 - 寶田望愛實', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/6b519399a99a/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('202', '38', '0', '0', 'NSFS-156 完蛋14 與被強暴的男人一起瘋狂的妻子～被討厭她的姐夫強行抱著……～倉田真央 - 倉多真央', '', 'NSFS156wandan14yubeiqiangbaodenanrenyiqifengkuangdeqizibeitaoyantadejiefuqiangxingbaozhucangtianzhenyangcangduozhenyang', '1', 'N', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/30808_cover_2025-02-22_214359.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/30808_cover_2025-02-22_214359.jpg', '', '', '', '', 'NSFS-156 完蛋14 與被強暴的男人一起瘋狂的妻子～被討厭她的姐夫強行抱著……～倉田真央 - 倉多真央', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '90', '587', '139', '284', '', '406', '170', '6.0', '786', '131', '1740423636', '1740401435', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'NSFS-156 完蛋14 與被強暴的男人一起瘋狂的妻子～被討厭她的姐夫強行抱著……～倉田真央 - 倉多真央', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/5ba84afad038/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('201', '38', '0', '0', 'HOMA-125 與因誤會自然消失的前女友重逢七年後，我們忘記了時間，多次發生性關係來確認我們的愛。', '', 'HOMA125yuyinwuhuiziranxiaoshideqiannvyouzhongfengqinianhouwomenwangjiliaoshijianduocifashengxingguanxilaiquerenwomendeai', '1', 'H', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/55542_cover_2025-02-22_213458.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/55542_cover_2025-02-22_213458.jpg', '', '', '', '', 'HOMA-125 與因誤會自然消失的前女友重逢七年後，我們忘記了時間，多次發生性關係來確認我們的愛。', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '55', '98', '507', '355', '', '867', '209', '8.0', '6984', '873', '1740423636', '1740401975', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'HOMA-125 與因誤會自然消失的前女友重逢七年後，我們忘記了時間，多次發生性關係來確認我們的愛。', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/81fffaeeb9f6/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('200', '38', '0', '0', 'FLAV-316 傳聞中的偶像女學生是用肉感巨乳勾引老男人的小惡魔蕩婦 南沫沫 - 美波もも', '', 'FLAV316chuanwenzhongdeouxiangnvxueshengshiyongrouganjurugouyinlaonanrendexiaoemodangfunanmomomeibo', '1', 'F', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/65340_cover_2025-02-22_214359.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/65340_cover_2025-02-22_214359.jpg', '', '', '', '', 'FLAV-316 傳聞中的偶像女學生是用肉感巨乳勾引老男人的小惡魔蕩婦 南沫沫 - 美波もも', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '764', '161', '669', '399', '', '358', '421', '6.0', '5328', '888', '1740423636', '1740402395', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'FLAV-316 傳聞中的偶像女學生是用肉感巨乳勾引老男人的小惡魔蕩婦 南沫沫 - 美波もも', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/05ec7de81c9f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('198', '38', '0', '0', 'WO-010 Boob Road 小月芽衣 - 沙月芽衣', '', 'WO010BoobRoadxiaoyueyayishayueyayi', '1', 'W', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/57685_cover_2025-02-22_220000.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/57685_cover_2025-02-22_220000.jpg', '', '', '', '', 'WO-010 Boob Road 小月芽衣 - 沙月芽衣', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '233', '336', '861', '958', '', '375', '770', '1.0', '22', '22', '1740423636', '1740403475', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'WO-010 Boob Road 小月芽衣 - 沙月芽衣', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/f65cfbc43129/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('199', '38', '0', '0', 'MDBK-277 極品美女巨乳×大量化妝水不可避免的高潮！ ！ Ege-connected 黏糊糊閃亮的肉質交付健康', '', 'MDBK277jipinmeinvjurudalianghuazhuangshuibukebimiandegaochaoEgeconnectednianhuhushanliangderouzhijiaofujiankang', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/38054_cover_2025-02-22_214359.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/38054_cover_2025-02-22_214359.jpg', '', '', '', '', 'MDBK-277 極品美女巨乳×大量化妝水不可避免的高潮！ ！ Ege-connected 黏糊糊閃亮的肉質交付健康', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '671', '161', '19', '16', '', '200', '70', '10.0', '4000', '400', '1740423636', '1740402936', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MDBK-277 極品美女巨乳×大量化妝水不可避免的高潮！ ！ Ege-connected 黏糊糊閃亮的肉質交付健康', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/e84709330144/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('197', '38', '0', '0', 'FLAV-315 重磅炸彈 肉食受虐狂 兔女郎 賤人若宮羽月 - 若宮葉月', '', 'FLAV315zhongbangzhadanroushishounuekuangtunvlangjianrenruogongyuyueruogongyeyue', '1', 'F', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/51769_cover_2025-02-22_220000.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/51769_cover_2025-02-22_220000.jpg', '', '', '', '', 'FLAV-315 重磅炸彈 肉食受虐狂 兔女郎 賤人若宮羽月 - 若宮葉月', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '265', '415', '54', '529', '', '280', '540', '6.0', '228', '38', '1740423632', '1740404015', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'FLAV-315 重磅炸彈 肉食受虐狂 兔女郎 賤人若宮羽月 - 若宮葉月', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/2419a955b99c/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('196', '38', '0', '0', 'MDBK-276 在最後一班火車上，我獨自一人，坐在我對面的是一個微醺的蕩婦。 - 希咲アリス', '', 'MDBK276zaizuihouyibanhuocheshangwoduziyirenzuozaiwoduimiandeshiyigeweixundedangfuxixiao', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/56313_cover_2025-02-22_220000.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/56313_cover_2025-02-22_220000.jpg', '', '', '', '', 'MDBK-276 在最後一班火車上，我獨自一人，坐在我對面的是一個微醺的蕩婦。 - 希咲アリス', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '299', '423', '281', '697', '', '270', '483', '2.0', '1942', '971', '1740423632', '1740404555', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MDBK-276 在最後一班火車上，我獨自一人，坐在我對面的是一個微醺的蕩婦。 - 希咲アリス', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/aa4686292185/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('195', '38', '0', '0', 'BAB-081 曬黑的 GAL 和調皮的一天 Rumina Sena - 瀬那ルミナ', '', 'BAB081shaiheideGALhediaopideyitianRuminaSenalaina', '1', 'B', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/47512_cover_2025-02-22_221832.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/47512_cover_2025-02-22_221832.jpg', '', '', '', '', 'BAB-081 曬黑的 GAL 和調皮的一天 Rumina Sena - 瀬那ルミナ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '200', '22', '668', '999', '', '965', '69', '8.0', '2104', '263', '1740423632', '1740405095', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'BAB-081 曬黑的 GAL 和調皮的一天 Rumina Sena - 瀬那ルミナ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/3110f2e17798/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('194', '38', '0', '0', 'KATU-110 巨乳×巨臀×蕩婦泡妞超短裙巨乳超蕩婦！', '', 'KATU110jurujutundangfupaoniuchaoduanqunjuruchaodangfu', '1', 'K', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/99357_cover_2025-02-22_221832.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/99357_cover_2025-02-22_221832.jpg', '', '', '', '', 'KATU-110 巨乳×巨臀×蕩婦泡妞超短裙巨乳超蕩婦！', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '13', '115', '240', '306', '', '259', '385', '10.0', '10', '1', '1740423632', '1740405635', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'KATU-110 巨乳×巨臀×蕩婦泡妞超短裙巨乳超蕩婦！', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/c93e4331e6f0/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('193', '38', '0', '0', 'AVSA-231 超強貼合特寫黑辣妹反兔兔巨乳豐滿火辣狂蘭卡 - 蘭華', '', 'AVSA231chaoqiangtiehetexieheilameifantutujurufengmanhuolakuanglankalanhua', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/64455_cover_2025-02-22_221832.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/64455_cover_2025-02-22_221832.jpg', '', '', '', '', 'AVSA-231 超強貼合特寫黑辣妹反兔兔巨乳豐滿火辣狂蘭卡 - 蘭華', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '303', '218', '140', '904', '', '989', '693', '1.0', '529', '529', '1740423632', '1740405995', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'AVSA-231 超強貼合特寫黑辣妹反兔兔巨乳豐滿火辣狂蘭卡 - 蘭華', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/ba9daff75f44/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('192', '38', '0', '0', 'DLDSS-159 推不動的巨乳美容師是通過按摩子宮讓蝦肉翹臀高潮的精油按摩超敏感走在路上就濕身', '', 'DLDSS159tuibudongdejurumeirongshishitongguoanmozigongrangxiarouqiaotungaochaodejingyouanmochaominganzouzailushangjiushishen', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/99260_cover_2025-02-22_223233.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/99260_cover_2025-02-22_223233.jpg', '', '', '', '', 'DLDSS-159 推不動的巨乳美容師是通過按摩子宮讓蝦肉翹臀高潮的精油按摩超敏感走在路上就濕身', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '381', '296', '8', '712', '', '321', '456', '5.0', '4180', '836', '1740423632', '1740406536', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DLDSS-159 推不動的巨乳美容師是通過按摩子宮讓蝦肉翹臀高潮的精油按摩超敏感走在路上就濕身', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/695fdd4a9245/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('191', '38', '0', '0', 'MGOLD-012 沒有公司存在的大屁股平底眼鏡辦公室女郎，一叫就讓你馬上做愛，但我卻被帶上性愛坐騎 二之宮', '', 'MGOLD012meiyougongsicunzaidedapigupingdiyanjingbangongshinvlangyijiaojiurangnimashangzuoaidanwoquebeidaishangxingaizuoqierzhigong', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/16586_cover_2025-02-22_223233.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/16586_cover_2025-02-22_223233.jpg', '', '', '', '', 'MGOLD-012 沒有公司存在的大屁股平底眼鏡辦公室女郎，一叫就讓你馬上做愛，但我卻被帶上性愛坐騎 二之宮', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '10', '772', '960', '774', '', '419', '466', '3.0', '195', '65', '1740423632', '1740407075', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MGOLD-012 沒有公司存在的大屁股平底眼鏡辦公室女郎，一叫就讓你馬上做愛，但我卻被帶上性愛坐騎 二之宮', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/c48c6266499d/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('190', '38', '0', '0', 'DLDSS-161 我們會派出一位蕩婦泡澡女士，她可以在您體內射精多次，想射多少次都行。繪宮花宮', '', 'DLDSS161womenhuipaichuyiweidangfupaozaonvshitakeyizainintineishejingduocixiangsheduoshaociduxinghuigonghuagong', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/75320_cover_2025-02-22_223233.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/75320_cover_2025-02-22_223233.jpg', '', '', '', '', 'DLDSS-161 我們會派出一位蕩婦泡澡女士，她可以在您體內射精多次，想射多少次都行。繪宮花宮', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '298', '525', '293', '775', '', '500', '358', '9.0', '1971', '219', '1740423632', '1740407615', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DLDSS-161 我們會派出一位蕩婦泡澡女士，她可以在您體內射精多次，想射多少次都行。繪宮花宮', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/40b6e7771ee5/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('189', '38', '0', '0', 'AARM-155 4P后宮對早洩男孩來說太折磨了，禁止高潮90分鐘，一直摸索和乳頭，女牛位做愛', '', 'AARM1554Phougongduizaoxienanhailaishuitaizhemoliaojinzhigaochao90fenzhongyizhimosuoherutounvniuweizuoai', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/85642_cover_2025-02-22_224605.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/85642_cover_2025-02-22_224605.jpg', '', '', '', '', 'AARM-155 4P后宮對早洩男孩來說太折磨了，禁止高潮90分鐘，一直摸索和乳頭，女牛位做愛', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '246', '465', '195', '305', '', '970', '250', '7.0', '5068', '724', '1740423632', '1740408155', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'AARM-155 4P后宮對早洩男孩來說太折磨了，禁止高潮90分鐘，一直摸索和乳頭，女牛位做愛', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/b747f162013c/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('188', '38', '0', '0', 'DLDSS-156 直到早上和打工的人妻因為突如其來的大雨難以回家…… - 穗高結花', '', 'DLDSS156zhidaozaoshanghedagongderenqiyinweituruqilaidedayunanyihuijiasuigaojiehua', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/80821_cover_2025-02-22_224605.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/80821_cover_2025-02-22_224605.jpg', '', '', '', '', 'DLDSS-156 直到早上和打工的人妻因為突如其來的大雨難以回家…… - 穗高結花', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '460', '201', '374', '140', '', '682', '958', '5.0', '2780', '556', '1740423632', '1740408695', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DLDSS-156 直到早上和打工的人妻因為突如其來的大雨難以回家…… - 穗高結花', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a2992aede115/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('187', '38', '0', '0', 'MCSR-512 中出人妻出軌旅行押川由里 - 推川悠里', '', 'MCSR512zhongchurenqichuguilvxingyachuanyoulituichuanyouli', '1', 'M', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/75356_cover_2025-02-22_224605.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/75356_cover_2025-02-22_224605.jpg', '', '', '', '', 'MCSR-512 中出人妻出軌旅行押川由里 - 推川悠里', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '287', '336', '556', '712', '', '413', '50', '1.0', '400', '400', '1740423632', '1740409235', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'MCSR-512 中出人妻出軌旅行押川由里 - 推川悠里', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/99dc95e9f9a0/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('186', '38', '0', '0', 'WFR-025 敏感的乳頭和早洩 Ji 停止射精控制無休止地殺死 Po Maya Kikuchi - 菊池まや', '', 'WFR025minganderutouhezaoxieJitingzhishejingkongzhiwuxiuzhidishasiPoMayaKikuchijuchi', '1', 'W', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/40129_cover_2025-02-22_231336.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/40129_cover_2025-02-22_231336.jpg', '', '', '', '', 'WFR-025 敏感的乳頭和早洩 Ji 停止射精控制無休止地殺死 Po Maya Kikuchi - 菊池まや', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '12', '507', '335', '171', '', '328', '914', '7.0', '1603', '229', '1740423632', '1740409595', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'WFR-025 敏感的乳頭和早洩 Ji 停止射精控制無休止地殺死 Po Maya Kikuchi - 菊池まや', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a5a82efecddf/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('185', '38', '0', '0', 'DVDMS-912 馬上鞍上白皙的十驢家政阿姨！被大雞巴迷住的人妻第二天就進入自己的身體', '', 'DVDMS912mashanganshangbaixideshilvjiazhengayibeidajibamizhuderenqidiertianjiujinruzijideshenti', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/90968_cover_2025-02-22_230336.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/90968_cover_2025-02-22_230336.jpg', '', '', '', '', 'DVDMS-912 馬上鞍上白皙的十驢家政阿姨！被大雞巴迷住的人妻第二天就進入自己的身體', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '669', '903', '490', '247', '', '767', '685', '5.0', '2845', '569', '1740423632', '1740410135', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DVDMS-912 馬上鞍上白皙的十驢家政阿姨！被大雞巴迷住的人妻第二天就進入自己的身體', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/60a82a52c4af/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('178', '38', '0', '0', 'SAME-041 寄生蟲強姦犯年輕妻子 Erika Ozaki 在逃亡中被銀行劫匪擁抱 - 尾崎えりか', '', 'SAME041jishengchongqiangjianfannianqingqiziErikaOzakizaitaowangzhongbeiyinxingjiefeiyongbaoweiqi', '1', 'S', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/70366_cover_2025-02-22_233208.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/70366_cover_2025-02-22_233208.jpg', '', '', '', '', 'SAME-041 寄生蟲強姦犯年輕妻子 Erika Ozaki 在逃亡中被銀行劫匪擁抱 - 尾崎えりか', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '978', '896', '830', '576', '', '446', '408', '8.0', '6000', '750', '1740423632', '1740413735', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'SAME-041 寄生蟲強姦犯年輕妻子 Erika Ozaki 在逃亡中被銀行劫匪擁抱 - 尾崎えりか', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/25/5f147c2d0bc0/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('179', '38', '0', '0', 'WAAA-241 中出中毒公共飛行女人誰可以排隊富爸爸的追求播種新聞20連續狂歡花成麻衣 - 花狩舞', '', 'WAAA241zhongchuzhongdugonggongfeixingnvrenshuikeyipaiduifubabadezhuiqiubozhongxinwen20lianxukuanghuanhuachengmayihuashouwu', '1', 'W', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/71472_cover_2025-02-22_233208.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/71472_cover_2025-02-22_233208.jpg', '', '', '', '', 'WAAA-241 中出中毒公共飛行女人誰可以排隊富爸爸的追求播種新聞20連續狂歡花成麻衣 - 花狩舞', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '630', '713', '803', '305', '', '958', '484', '6.0', '168', '28', '1740423632', '1740413195', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'WAAA-241 中出中毒公共飛行女人誰可以排隊富爸爸的追求播種新聞20連續狂歡花成麻衣 - 花狩舞', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/25/b6198c651195/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('180', '38', '0', '0', 'ADN-420 對不起...被丈夫最好的朋友抱著的光公主 - 妃光莉', '', 'ADN420duibuqibeizhangfuzuihaodepengyoubaozhudeguanggongzhufeiguangli', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/58770_cover_2025-02-22_233208.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/58770_cover_2025-02-22_233208.jpg', '', '', '', '', 'ADN-420 對不起...被丈夫最好的朋友抱著的光公主 - 妃光莉', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '598', '560', '616', '330', '', '157', '67', '6.0', '2418', '403', '1740423632', '1740412835', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ADN-420 對不起...被丈夫最好的朋友抱著的光公主 - 妃光莉', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/be4d143c295b/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('181', '38', '0', '0', 'ABW-322 Climax Lingerie Na 精湛的內衣性交，突出了纖細的身體 Mai Nanashima - 七嶋舞', '', 'ABW322ClimaxLingerieNajingzhandeneiyixingjiaotuchuliaoxianxideshentiMaiNanashimaqidaowu', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/51471_cover_2025-02-22_230336.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/51471_cover_2025-02-22_230336.jpg', '', '', '', '', 'ABW-322 Climax Lingerie Na 精湛的內衣性交，突出了纖細的身體 Mai Nanashima - 七嶋舞', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '67', '976', '600', '254', '', '375', '165', '10.0', '6950', '695', '1740423632', '1740412295', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ABW-322 Climax Lingerie Na 精湛的內衣性交，突出了纖細的身體 Mai Nanashima - 七嶋舞', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/df595c57d32f/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('182', '38', '0', '0', 'ABW-321 每天只是在一無所有的鄉下，和青梅竹馬做著汗流浹背的豐盛性愛。 case.06 燒海海 - 八挂うみ', '', 'ABW321meitianzhishizaiyiwusuoyoudexiangxiaheqingmeizhumazuozhuhanliujiabeidefengshengxingaicase06shaohaihaibagua', '1', 'A', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/22733_cover_2025-02-22_230336.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/22733_cover_2025-02-22_230336.jpg', '', '', '', '', 'ABW-321 每天只是在一無所有的鄉下，和青梅竹馬做著汗流浹背的豐盛性愛。 case.06 燒海海 - 八挂うみ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '104', '72', '218', '338', '', '488', '327', '5.0', '1405', '281', '1740423632', '1740411817', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'ABW-321 每天只是在一無所有的鄉下，和青梅竹馬做著汗流浹背的豐盛性愛。 case.06 燒海海 - 八挂うみ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/04da783b504d/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('183', '38', '0', '0', 'DVRT-017 雙手受傷時被哥哥強暴多次被射精 葉月萌', '', 'DVRT017shuangshoushoushangshibeigegeqiangbaoduocibeishejingyeyuemeng', '1', 'D', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/66111_cover_2025-02-22_231336.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/66111_cover_2025-02-22_231336.jpg', '', '', '', '', 'DVRT-017 雙手受傷時被哥哥強暴多次被射精 葉月萌', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '571', '774', '935', '580', '', '901', '751', '8.0', '2944', '368', '1740423632', '1740411215', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'DVRT-017 雙手受傷時被哥哥強暴多次被射精 葉月萌', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/a51efdace664/playlist.m3u8', '', '', '', '', '0', '', '');
INSERT INTO `mac_vod` VALUES ('184', '38', '0', '0', 'RBK-064 貞操帶的女人 33 有賀美奈穗 - 有賀みなほ', '', 'RBK064zhencaodaidenvren33youhemeinaisuiyouhe', '1', 'R', '', '', '中文字幕', 'https://xbzyw5.top/video/m3u8/2025/02/22/99590_cover_2025-02-22_231336.jpg', '', '', 'https://xbzyw5.top/video/m3u8/2025/02/22/99590_cover_2025-02-22_231336.jpg', '', '', '', '', 'RBK-064 貞操帶的女人 33 有賀美奈穗 - 有賀みなほ', '', '', '0', '0', '', '', '', '', '0', '', '', '', '', '', '', '', '0', '0', '0', '1', '0', '0', '0', '0', '143', '595', '265', '186', '', '441', '542', '4.0', '3520', '880', '1740423632', '1740410622', '0', '0', '0', '0', '0.0', '', '', '', '', '', '', '', '', '', 'RBK-064 貞操帶的女人 33 有賀美奈穗 - 有賀みなほ', 'xxbm3u8', '', '', 'https://xbzyw5.top/video/m3u8/202502/24/8283562898d4/playlist.m3u8', '', '', '', '', '0', '', '');

-- ----------------------------
-- Table structure for mac_vodsearch
-- ----------------------------
DROP TABLE IF EXISTS `mac_vodsearch`;
CREATE TABLE `mac_vodsearch` (
  `search_key` char(32) CHARACTER SET ascii COLLATE ascii_bin NOT NULL COMMENT '搜索键（关键词md5）',
  `search_word` varchar(128) NOT NULL COMMENT '搜索关键词',
  `search_field` varchar(64) CHARACTER SET ascii COLLATE ascii_bin NOT NULL COMMENT '搜索字段名（可有多个，用|分隔）',
  `search_hit_count` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '搜索命中次数',
  `search_last_hit_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最近命中时间',
  `search_update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `search_result_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '结果Id数量',
  `search_result_ids` mediumtext CHARACTER SET ascii COLLATE ascii_bin NOT NULL COMMENT '搜索结果Id列表，英文半角逗号分隔',
  PRIMARY KEY (`search_key`),
  KEY `search_field` (`search_field`),
  KEY `search_update_time` (`search_update_time`),
  KEY `search_hit_count` (`search_hit_count`),
  KEY `search_last_hit_time` (`search_last_hit_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='vod搜索缓存表';

-- ----------------------------
-- Records of mac_vodsearch
-- ----------------------------

-- ----------------------------
-- Table structure for mac_website
-- ----------------------------
DROP TABLE IF EXISTS `mac_website`;
CREATE TABLE `mac_website` (
  `website_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type_id_1` smallint(5) unsigned NOT NULL DEFAULT '0',
  `website_name` varchar(60) NOT NULL DEFAULT '',
  `website_sub` varchar(255) NOT NULL DEFAULT '',
  `website_en` varchar(255) NOT NULL DEFAULT '',
  `website_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `website_letter` char(1) NOT NULL DEFAULT '',
  `website_color` varchar(6) NOT NULL DEFAULT '',
  `website_lock` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `website_sort` int(10) NOT NULL DEFAULT '0',
  `website_jumpurl` varchar(255) NOT NULL DEFAULT '',
  `website_pic` varchar(1024) NOT NULL DEFAULT '',
  `website_pic_screenshot` text,
  `website_logo` varchar(255) NOT NULL DEFAULT '',
  `website_area` varchar(20) NOT NULL DEFAULT '',
  `website_lang` varchar(10) NOT NULL DEFAULT '',
  `website_level` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `website_time` int(10) unsigned NOT NULL DEFAULT '0',
  `website_time_add` int(10) unsigned NOT NULL DEFAULT '0',
  `website_time_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `website_time_make` int(10) unsigned NOT NULL DEFAULT '0',
  `website_time_referer` int(10) unsigned NOT NULL DEFAULT '0',
  `website_hits` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_hits_day` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_hits_week` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_hits_month` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_score` decimal(3,1) unsigned NOT NULL DEFAULT '0.0',
  `website_score_all` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_score_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_up` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_down` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_referer` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_referer_day` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_referer_week` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_referer_month` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `website_tag` varchar(100) NOT NULL DEFAULT '',
  `website_class` varchar(255) NOT NULL DEFAULT '',
  `website_remarks` varchar(100) NOT NULL DEFAULT '',
  `website_tpl` varchar(30) NOT NULL DEFAULT '',
  `website_blurb` varchar(255) NOT NULL DEFAULT '',
  `website_content` mediumtext NOT NULL,
  PRIMARY KEY (`website_id`),
  KEY `type_id` (`type_id`),
  KEY `type_id_1` (`type_id_1`),
  KEY `website_name` (`website_name`),
  KEY `website_en` (`website_en`),
  KEY `website_letter` (`website_letter`),
  KEY `website_sort` (`website_sort`),
  KEY `website_lock` (`website_lock`),
  KEY `website_time` (`website_time`),
  KEY `website_time_add` (`website_time_add`),
  KEY `website_time_referer` (`website_time_referer`),
  KEY `website_hits` (`website_hits`),
  KEY `website_hits_day` (`website_hits_day`),
  KEY `website_hits_week` (`website_hits_week`),
  KEY `website_hits_month` (`website_hits_month`),
  KEY `website_time_make` (`website_time_make`),
  KEY `website_score` (`website_score`),
  KEY `website_score_all` (`website_score_all`),
  KEY `website_score_num` (`website_score_num`),
  KEY `website_up` (`website_up`),
  KEY `website_down` (`website_down`),
  KEY `website_level` (`website_level`),
  KEY `website_tag` (`website_tag`),
  KEY `website_class` (`website_class`),
  KEY `website_referer` (`website_referer`),
  KEY `website_referer_day` (`website_referer_day`),
  KEY `website_referer_week` (`website_referer_week`),
  KEY `website_referer_month` (`website_referer_month`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of mac_website
-- ----------------------------
